/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.fluid;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public final class GridFluidStorage
implements IFluidHandler,
INBTSerializable<CompoundTag> {
    private int baseCapacity;
    private int capacity;
    private FluidStack fluid = FluidStack.EMPTY;
    private byte sampleTracker = 0;
    private final int[] samplesOut = new int[40];
    private int rollingOut = 0;
    private int averageOut = 0;

    public GridFluidStorage(int baseCapacity) {
        this.baseCapacity = baseCapacity;
    }

    public GridFluidStorage setBaseCapacity(int baseCapacity) {
        this.baseCapacity = Math.max(0, baseCapacity);
        return this;
    }

    public GridFluidStorage setCapacity(int capacity) {
        this.capacity = capacity;
        this.resetTrackers();
        return this;
    }

    public GridFluidStorage setFluid(FluidStack fluid) {
        this.fluid = fluid.copy();
        return this;
    }

    public void resetTrackers() {
        this.sampleTracker = 0;
        this.rollingOut = 0;
        this.averageOut = 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void tick() {
        this.samplesOut[this.sampleTracker] = this.fluid.getAmount();
    }

    public void postTick() {
        byte by = this.sampleTracker;
        this.samplesOut[by] = this.samplesOut[by] - this.fluid.getAmount();
        this.rollingOut += this.samplesOut[this.sampleTracker];
        this.averageOut = this.rollingOut / this.samplesOut.length;
        this.sampleTracker = (byte)(this.sampleTracker + 1);
        if (this.sampleTracker >= this.samplesOut.length) {
            this.sampleTracker = 0;
            this.updateCapacity();
        }
        this.rollingOut -= this.samplesOut[this.sampleTracker];
        this.samplesOut[this.sampleTracker] = 0;
    }

    private void updateCapacity() {
        this.capacity = Math.max(this.baseCapacity, 4 * this.averageOut);
    }

    public GridFluidStorage read(CompoundTag nbt) {
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt));
        this.baseCapacity = nbt.m_128451_("Capacity");
        this.averageOut = nbt.m_128451_("TrackOut");
        this.updateCapacity();
        return this;
    }

    public CompoundTag write(CompoundTag nbt) {
        this.fluid.writeToNBT(nbt);
        nbt.m_128405_("Capacity", this.baseCapacity);
        nbt.m_128405_("TrackOut", this.averageOut);
        return nbt;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.setFluid(new FluidStack(resource, Math.min(this.capacity, resource.getAmount())));
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        if (this.fluid.getAmount() >= this.capacity) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute()) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.setFluid(FluidStack.EMPTY);
            }
        }
        return stack;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }
}

