/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;

public class ProcessUtils {
    public static CompletableFuture<Process> onExit(Process process) {
        return CompletableFuture.supplyAsync(() -> ProcessUtils.waitFor(process));
    }

    private static Process waitFor(final Process process) {
        boolean interrupted = false;
        while (true) {
            try {
                ForkJoinPool.managedBlock(new ForkJoinPool.ManagedBlocker(){

                    @Override
                    public boolean block() throws InterruptedException {
                        process.waitFor();
                        return true;
                    }

                    @Override
                    public boolean isReleasable() {
                        return !process.isAlive();
                    }
                });
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return process;
    }
}

