/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.network.packet;

import com.maciej916.maenchants.common.capabilities.player.IPlayerCapability;
import com.maciej916.maenchants.common.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketMultiJumpSync {
    private final int multiJump;

    public PacketMultiJumpSync(int multiJump) {
        this.multiJump = multiJump;
    }

    public PacketMultiJumpSync(ByteBuf buf) {
        this.multiJump = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.multiJump);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (player != null);
            IPlayerCapability enchantsCap = PlayerUtil.getEnchantsCapability((Player)player);
            enchantsCap.setMultiJump(this.multiJump);
        });
        ctx.get().setPacketHandled(true);
    }
}

