/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.network.packet;

import com.maciej916.maenchants.common.capabilities.player.IPlayerCapability;
import com.maciej916.maenchants.common.util.PlayerUtil;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PacketLumberjackToggle {
    private final boolean toggle;

    public PacketLumberjackToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public PacketLumberjackToggle(ByteBuf buf) {
        this.toggle = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.toggle);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (ctx.get() == null || ((NetworkEvent.Context)ctx.get()).getSender() == null) {
                return;
            }
            IPlayerCapability enchantsCap = PlayerUtil.getEnchantsCapability((Player)((NetworkEvent.Context)ctx.get()).getSender());
            enchantsCap.setExcavateActive(this.toggle);
        });
        ctx.get().setPacketHandled(true);
    }
}

