/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maenchants.common.handler;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.maciej916.maenchants.common.capabilities.player.IPlayerCapability;
import com.maciej916.maenchants.common.client.ModKeys;
import com.maciej916.maenchants.common.network.ModNetworking;
import com.maciej916.maenchants.common.network.packet.PacketLumberjackToggle;
import com.maciej916.maenchants.common.registries.ModEnchantments;
import com.maciej916.maenchants.common.util.PlayerUtil;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.level.BlockEvent;

public class HandlerLumberjack {
    private static final HashMultimap<Player, BlockPos> treeMap = HashMultimap.create();
    private static final TagKey<Block> MINECRAFT_LOGS = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "logs"));
    private static final TagKey<Block> FORGE_LOGS = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "logs"));

    @OnlyIn(value=Dist.CLIENT)
    public static void handlerKeyInput(Minecraft mc, InputEvent.Key event) {
        if (!mc.m_91302_() || mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability((Player)mc.f_91074_);
        if (enchantsCap != null) {
            if (ModKeys.EXCAVATE.m_90857_()) {
                if (!enchantsCap.getExcavateActive()) {
                    enchantsCap.setExcavateActive(true);
                    ModNetworking.INSTANCE.sendToServer((Object)new PacketLumberjackToggle(true));
                }
            } else if (enchantsCap.getExcavateActive()) {
                enchantsCap.setExcavateActive(false);
                ModNetworking.INSTANCE.sendToServer((Object)new PacketLumberjackToggle(false));
            }
        }
    }

    public static void handlerBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(player.m_7655_());
        int lvl = stack.getEnchantmentLevel((Enchantment)ModEnchantments.LUMBERJACK.get());
        if (lvl == 0) {
            return;
        }
        IPlayerCapability enchantsCap = PlayerUtil.getAliveEnchantsCapability(player);
        if (enchantsCap == null) {
            return;
        }
        if (enchantsCap.getExcavateActive()) {
            BlockState state = event.getState();
            if (state.m_204336_(MINECRAFT_LOGS) || state.m_204336_(FORGE_LOGS)) {
                Level world = (Level)event.getLevel();
                BlockPos pos = event.getPos();
                HandlerLumberjack.findTree(player, world, pos, state);
                if (treeMap.get((Object)player).size() < 512) {
                    HandlerLumberjack.doBreak(player, world, pos);
                    event.setCanceled(true);
                } else {
                    treeMap.asMap().remove(player);
                }
            }
        } else {
            treeMap.asMap().remove(player);
        }
    }

    public static void doBreak(Player player, Level world, BlockPos pos) {
        int logsBreak = 0;
        Block block = world.m_8055_(pos).m_60734_();
        InteractionHand hand = player.m_7655_();
        ItemStack stack = player.m_21120_(hand);
        for (BlockPos point : ImmutableSet.copyOf((Collection)treeMap.get((Object)player))) {
            if (stack.m_41773_() < 0) break;
            ++logsBreak;
            world.m_7731_(point, Blocks.f_50016_.m_49966_(), 3);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        ItemEntity item = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)block, logsBreak));
        world.m_7967_((Entity)item);
        treeMap.asMap().remove(player);
    }

    private static void findTree(Player player, Level world, BlockPos mine, BlockState state) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 1; ++offsetY) {
                    boolean isLeaves;
                    BlockPos newPoint = mine.m_7918_(offsetX, offsetY, offsetZ);
                    if (treeMap.containsEntry((Object)player, (Object)newPoint)) continue;
                    BlockState newBlockState = world.m_8055_(newPoint);
                    boolean bl = isLeaves = newBlockState.m_60767_() == Material.f_76274_;
                    if (newBlockState.m_60734_() != state.m_60734_() || isLeaves) continue;
                    treeMap.put((Object)player, (Object)newPoint);
                    HandlerLumberjack.findTree(player, world, newPoint, state);
                }
            }
        }
    }
}

