/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AABBUtils {
    public static AABB expand(AABB aabb, double amt) {
        return aabb.m_82377_(amt, amt, amt);
    }

    public static AABB translate(AABB aabb, double x, double y, double z) {
        return aabb.m_82386_(x, y, z);
    }

    public static AABB rotate(AABB aabb, Direction facing) {
        switch (facing) {
            case UP: {
                return aabb;
            }
            case DOWN: {
                return new AABB(aabb.f_82288_, 1.0 - aabb.f_82289_, aabb.f_82290_, aabb.f_82291_, 1.0 - aabb.f_82292_, aabb.f_82293_);
            }
            case EAST: {
                return new AABB(aabb.f_82289_, 1.0 - aabb.f_82290_, 1.0 - aabb.f_82288_, aabb.f_82292_, 1.0 - aabb.f_82293_, 1.0 - aabb.f_82291_);
            }
            case WEST: {
                return new AABB(1.0 - aabb.f_82289_, 1.0 - aabb.f_82290_, aabb.f_82288_, 1.0 - aabb.f_82292_, 1.0 - aabb.f_82293_, aabb.f_82291_);
            }
            case NORTH: {
                return new AABB(1.0 - aabb.f_82288_, 1.0 - aabb.f_82290_, 1.0 - aabb.f_82289_, 1.0 - aabb.f_82291_, 1.0 - aabb.f_82293_, 1.0 - aabb.f_82292_);
            }
            case SOUTH: {
                return new AABB(aabb.f_82288_, 1.0 - aabb.f_82290_, aabb.f_82289_, aabb.f_82291_, 1.0 - aabb.f_82293_, aabb.f_82292_);
            }
        }
        return aabb;
    }

    public static Boolean testOcclusion(VoxelShape shape1, VoxelShape shape2) {
        return shape1.m_83299_().stream().anyMatch(s -> shape2.m_83299_().stream().anyMatch(arg_0 -> ((AABB)s).m_82381_(arg_0)));
    }

    public static VoxelShape rotate(VoxelShape shape, Direction facing) {
        VoxelShape out = Shapes.m_83040_();
        for (AABB aabb : shape.m_83299_()) {
            aabb = AABBUtils.rotate(aabb, facing);
            out = Shapes.m_83110_((VoxelShape)out, (VoxelShape)Block.m_49796_((double)(aabb.f_82288_ * 16.0), (double)(aabb.f_82289_ * 16.0), (double)(aabb.f_82290_ * 16.0), (double)(aabb.f_82291_ * 16.0), (double)(aabb.f_82292_ * 16.0), (double)(aabb.f_82293_ * 16.0)));
        }
        return out;
    }
}

