/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.power.BlutricityFEStorage;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.block.power.BlockEngine;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileMachineBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEngine
extends TileMachineBase {
    public boolean isActive = false;
    public byte pumpTick = 0;
    public byte pumpSpeed;
    private final BlutricityFEStorage storage = new BlutricityFEStorage(320.0){

        @Override
        public boolean canReceive() {
            return false;
        }
    };
    private LazyOptional<BlutricityFEStorage> blutricityCap;

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBlutricity.BLUTRICITY_CAPABILITY || cap == CapabilityEnergy.ENERGY) {
            if (this.blutricityCap == null) {
                this.blutricityCap = LazyOptional.of(() -> this.storage);
            }
            return this.blutricityCap.cast();
        }
        return LazyOptional.empty();
    }

    public TileEngine(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.ENGINE.get(), pos, state);
        this.pumpSpeed = (byte)16;
    }

    public static void tickEngine(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        Direction facing;
        BlockEntity tileEntity;
        TileEngine engine = (TileEngine)blockEntity;
        engine.storage.resetCurrent();
        engine.isActive = false;
        if (level != null && !level.f_46443_ && engine.storage.getEnergyStored() > 0 && level.m_46753_(engine.f_58858_) && (tileEntity = level.m_7702_(pos.m_121945_(facing = ((Direction)engine.m_58900_().m_61143_(BlockEngine.FACING)).m_122424_()))) != null) {
            tileEntity.getCapability(CapabilityEnergy.ENERGY, facing.m_122424_()).ifPresent(other -> {
                int simulated = engine.storage.extractEnergy(320, true);
                int sent = other.receiveEnergy(simulated, false);
                int amount = engine.storage.extractEnergy(sent, false);
                if (amount > 0) {
                    engine.isActive = true;
                }
            });
        }
        if (level != null && !level.f_46443_ && (Boolean)engine.m_58900_().m_61143_((Property)BlockEngine.ACTIVE) != engine.isActive) {
            level.m_46597_(pos, (BlockState)engine.m_58900_().m_61124_((Property)BlockEngine.ACTIVE, (Comparable)Boolean.valueOf(engine.isActive)));
            engine.markForRenderUpdate();
        }
        if (level != null && ((Boolean)engine.m_58900_().m_61143_((Property)BlockEngine.ACTIVE)).booleanValue()) {
            engine.isActive = true;
            engine.pumpTick = (byte)(engine.pumpTick + 1);
            if (engine.pumpTick >= engine.pumpSpeed * 2) {
                engine.pumpTick = 0;
                if (engine.pumpSpeed > 4) {
                    engine.pumpSpeed = (byte)(engine.pumpSpeed - 1);
                }
            }
        } else {
            engine.isActive = false;
            engine.pumpTick = 0;
        }
    }

    @Override
    protected void writeToPacketNBT(CompoundTag compound) {
        super.writeToPacketNBT(compound);
        compound.m_128344_("pumpspeed", this.pumpSpeed);
        compound.m_128344_("pumptick", this.pumpTick);
        Tag nbtstorage = CapabilityBlutricity.writeNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null);
        compound.m_128365_("energy", nbtstorage);
    }

    @Override
    protected void readFromPacketNBT(CompoundTag compound) {
        super.readFromPacketNBT(compound);
        this.pumpSpeed = compound.m_128445_("pumpspeed");
        this.pumpTick = compound.m_128445_("pumptick");
        if (compound.m_128441_("energy")) {
            Tag nbtstorage = compound.m_128423_("energy");
            CapabilityBlutricity.readNBT(CapabilityBlutricity.BLUTRICITY_CAPABILITY, this.storage, null, nbtstorage);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.blutricityCap != null) {
            this.blutricityCap.invalidate();
            this.blutricityCap = null;
        }
    }
}

