/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.api.item.IDatabaseSaveable;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackDatabase;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileCircuitDatabase
extends TileCircuitTable {
    public Container copyInventory = new SimpleContainer(2){

        public void m_6836_(int slot, ItemStack itemStack) {
            super.m_6836_(slot, itemStack);
            if (slot == 0 && !itemStack.m_41619_()) {
                TileCircuitDatabase.this.nameTextField = itemStack.m_41611_().getString();
            }
        }
    };
    public int clientCurrentTab;
    public int curUploadProgress;
    public int curCopyProgress;
    public int selectedShareOption;
    public static final int UPLOAD_AND_COPY_TIME = 20;
    public final ItemStackDatabase stackDatabase = new ItemStackDatabase();
    public static List<ItemStack> serverDatabaseStacks = new ArrayList<ItemStack>();
    private Player triggeringPlayer;
    public String nameTextField = "";

    public TileCircuitDatabase(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static boolean hasPermissions(Player player) {
        if (((Boolean)BPConfig.CONFIG.serverCircuitSavingOpOnly.get()).booleanValue()) {
            // empty if block
        }
        return true;
    }

    @Override
    public void setText(int textFieldID, String text) {
        if (textFieldID == 1) {
            this.nameTextField = text;
            if (!this.copyInventory.m_8020_(0).m_41619_()) {
                this.copyInventory.m_8020_(0).m_41714_((Component)Component.m_237113_((String)this.nameTextField));
            }
        } else {
            super.setText(textFieldID, text);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return textFieldID == 1 ? this.nameTextField : super.getText(textFieldID);
    }

    public boolean copy(Player player, ItemStack template, ItemStack target, boolean simulate) {
        IDatabaseSaveable saveable;
        if (!template.m_41619_() && !target.m_41619_() && template.m_41656_(target) && (saveable = (IDatabaseSaveable)template.m_41720_()).canCopy(template, target)) {
            if (!player.m_7500_()) {
                List<ItemStack> stacksInTemplate = saveable.getItemsOnStack(template);
                List<ItemStack> stacksInOutput = saveable.getItemsOnStack(target);
                if (stacksInTemplate.isEmpty()) {
                    stacksInTemplate = new ArrayList<ItemStack>();
                }
                if (stacksInOutput.isEmpty()) {
                    stacksInOutput = new ArrayList<ItemStack>();
                }
                ArrayList<ItemStack> traversedItems = new ArrayList<ItemStack>();
                ArrayList<ItemStack> allApplicableItems = new ArrayList<ItemStack>();
                allApplicableItems.addAll(stacksInTemplate);
                allApplicableItems.addAll(stacksInOutput);
                for (ItemStack templateStack : allApplicableItems) {
                    boolean alreadyTraversed = false;
                    for (ItemStack itemStack : traversedItems) {
                        if (!itemStack.m_41656_(templateStack) || !ItemStack.m_41658_((ItemStack)itemStack, (ItemStack)templateStack)) continue;
                        alreadyTraversed = true;
                        break;
                    }
                    if (alreadyTraversed) continue;
                    traversedItems.add(templateStack);
                    int count = 0;
                    for (ItemStack stack : stacksInTemplate) {
                        if (!stack.m_41656_(templateStack) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count += stack.m_41613_();
                    }
                    for (ItemStack stack : stacksInOutput) {
                        if (!stack.m_41656_(templateStack) || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count -= stack.m_41613_();
                    }
                    if ((count *= target.m_41613_()) > 0) {
                        ItemStack itemStack = templateStack.m_41777_();
                        itemStack.m_41764_(count);
                        ItemStack itemStack2 = IOHelper.extract(this, null, itemStack, true, simulate, 2);
                        if (!itemStack2.m_41619_() && itemStack2.m_41613_() >= count) continue;
                        return false;
                    }
                    if (count >= 0) continue;
                    ItemStack itemStack = templateStack.m_41777_();
                    itemStack.m_41764_(-count);
                    ItemStack itemStack3 = IOHelper.insert(this, itemStack, null, simulate);
                    if (itemStack3.m_41619_() || simulate) continue;
                    IOHelper.spawnItemInWorld(this.f_58857_, itemStack3, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5);
                }
            }
            if (!simulate) {
                ItemStack copyStack = template.m_41777_();
                copyStack.m_41764_(target.m_41613_());
                this.copyInventory.m_6836_(1, copyStack);
            }
            return true;
        }
        return false;
    }

    public static void tickCircuitDatabase(Level level, BlockPos pos, BlockState state, TileCircuitDatabase tileCircuitDatabase) {
        TileBase.tickTileBase(level, pos, state, tileCircuitDatabase);
        if (!level.f_46443_) {
            if (!tileCircuitDatabase.copyInventory.m_8020_(0).m_41619_()) {
                if (tileCircuitDatabase.curCopyProgress >= 0 && ++tileCircuitDatabase.curCopyProgress > 20) {
                    tileCircuitDatabase.curCopyProgress = -1;
                    if (tileCircuitDatabase.copy(tileCircuitDatabase.triggeringPlayer, tileCircuitDatabase.copyInventory.m_8020_(0), tileCircuitDatabase.copyInventory.m_8020_(1), true)) {
                        tileCircuitDatabase.copy(tileCircuitDatabase.triggeringPlayer, tileCircuitDatabase.copyInventory.m_8020_(0), tileCircuitDatabase.copyInventory.m_8020_(1), false);
                    }
                }
                if (tileCircuitDatabase.curUploadProgress >= 0 && ++tileCircuitDatabase.curUploadProgress > 20) {
                    tileCircuitDatabase.curUploadProgress = -1;
                    if (tileCircuitDatabase.selectedShareOption == 1 && tileCircuitDatabase.triggeringPlayer != null && tileCircuitDatabase.selectedShareOption == 2) {
                        tileCircuitDatabase.stackDatabase.saveItemStack(tileCircuitDatabase.copyInventory.m_8020_(0));
                    }
                    tileCircuitDatabase.selectedShareOption = 0;
                }
            } else {
                tileCircuitDatabase.curCopyProgress = -1;
                tileCircuitDatabase.curUploadProgress = -1;
                tileCircuitDatabase.selectedShareOption = 0;
            }
        }
    }

    public void saveToPrivateLibrary(ItemStack stack) {
        this.stackDatabase.saveItemStack(stack);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        CompoundTag stackTag;
        super.m_183515_(tag);
        if (!this.copyInventory.m_8020_(0).m_41619_()) {
            stackTag = new CompoundTag();
            this.copyInventory.m_8020_(0).m_41739_(stackTag);
            tag.m_128365_("copyTemplateStack", (Tag)stackTag);
        }
        if (!this.copyInventory.m_8020_(1).m_41619_()) {
            stackTag = new CompoundTag();
            this.copyInventory.m_8020_(1).m_41739_(stackTag);
            tag.m_128365_("copyOutputStack", (Tag)stackTag);
        }
        tag.m_128405_("curUploadProgress", this.curUploadProgress);
        tag.m_128405_("curCopyProgress", this.curCopyProgress);
        tag.m_128344_("selectedShareOption", (byte)this.selectedShareOption);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("copyTemplateStack")) {
            this.copyInventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("copyTemplateStack")));
        } else {
            this.copyInventory.m_6836_(0, ItemStack.f_41583_);
        }
        if (tag.m_128441_("copyOutputStack")) {
            this.copyInventory.m_6836_(1, ItemStack.m_41712_((CompoundTag)tag.m_128469_("copyOutputStack")));
        } else {
            this.copyInventory.m_6836_(1, ItemStack.f_41583_);
        }
        this.curUploadProgress = tag.m_128451_("curUploadProgress");
        this.curCopyProgress = tag.m_128451_("curCopyProgress");
        this.selectedShareOption = tag.m_128445_("selectedShareOption");
    }
}

