/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.ContainerSortingMachine;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.TileMachineBase;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileSortingMachine
extends TileMachineBase
implements WorldlyContainer,
IGuiButtonSensitive,
MenuProvider {
    public int curColumn = 0;
    public PullMode pullMode = PullMode.SINGLE_STEP;
    public SortMode sortMode = SortMode.ANYSTACK_SEQUENTIAL;
    private boolean sweepTriggered;
    private int savedPulses;
    public static final int SLOTS = 40;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)40, (Object)ItemStack.f_41583_);
    public final IPneumaticTube.TubeColor[] colors = new IPneumaticTube.TubeColor[9];
    public int[] fuzzySettings = new int[8];
    private ItemStack nonAcceptedStack;

    public TileSortingMachine(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.SORTING_MACHINE.get(), pos, state);
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.NONE;
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"sorting_machine");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new ContainerSortingMachine(id, inventory, (Container)this);
    }

    public static void tickSorting(Level level, BlockPos pos, BlockState state, TileSortingMachine tileSortingMachine) {
        tileSortingMachine.nonAcceptedStack = ItemStack.f_41583_;
        TileBase.tickTileBase(level, pos, state, tileSortingMachine);
        if (!tileSortingMachine.sweepTriggered && tileSortingMachine.savedPulses > 0) {
            --tileSortingMachine.savedPulses;
            tileSortingMachine.sweepTriggered = true;
        }
        if (!level.f_46443_ && level.m_46467_() % 10L == 0L && (tileSortingMachine.pullMode == PullMode.SINGLE_SWEEP && tileSortingMachine.sweepTriggered || tileSortingMachine.pullMode == PullMode.AUTOMATIC)) {
            tileSortingMachine.triggerSorting();
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        if (newValue) {
            if (this.pullMode == PullMode.SINGLE_STEP) {
                this.triggerSorting();
            }
            if (this.pullMode == PullMode.SINGLE_SWEEP) {
                ++this.savedPulses;
            }
        }
    }

    private void triggerSorting() {
        block8: {
            int[] accessibleSlots;
            Container inputInv;
            block10: {
                block9: {
                    Direction dir = this.getOutputDirection().m_122424_();
                    BlockEntity inputTE = this.getTileCache(dir);
                    if (!(inputTE instanceof Container)) break block8;
                    inputInv = (Container)inputTE;
                    if (inputInv instanceof WorldlyContainer) {
                        accessibleSlots = ((WorldlyContainer)inputInv).m_7071_(dir.m_122424_());
                    } else {
                        accessibleSlots = new int[inputInv.m_6643_()];
                        for (int i = 0; i < accessibleSlots.length; ++i) {
                            accessibleSlots[i] = i;
                        }
                    }
                    for (int slot : accessibleSlots) {
                        ItemStack stack = inputInv.m_8020_(slot);
                        if (stack.m_41619_() || !IOHelper.canTakeItemThroughFaceFromInventory(inputInv, stack, slot, dir.m_122424_().ordinal()) || !this.tryProcessItem(stack, false)) continue;
                        if (stack.m_41613_() == 0) {
                            inputInv.m_6836_(slot, ItemStack.f_41583_);
                        }
                        return;
                    }
                    if (this.sortMode != SortMode.ANYSTACK_SEQUENTIAL) break block9;
                    for (int i = this.curColumn; i < this.inventory.size(); i += 8) {
                        ItemStack extractedStack;
                        ItemStack filterStack = (ItemStack)this.inventory.get(i);
                        if (filterStack.m_41619_() || (extractedStack = IOHelper.extract(inputTE, dir.m_122424_(), filterStack, true, false)).m_41619_()) continue;
                        this.addItemToOutputBuffer(extractedStack.m_41777_(), this.colors[this.curColumn]);
                        this.gotoNextNonEmptyColumn();
                        break block8;
                    }
                    break block8;
                }
                if (this.sortMode != SortMode.ALLSTACK_SEQUENTIAL) break block10;
                if (!this.matchAndProcessColumn(inputInv, accessibleSlots, this.curColumn)) break block8;
                this.gotoNextNonEmptyColumn();
                break block8;
            }
            if (this.sortMode == SortMode.RANDOM_ALLSTACKS) {
                for (int i = 0; i < 8 && !this.matchAndProcessColumn(inputInv, accessibleSlots, i); ++i) {
                }
            }
        }
    }

    @Override
    public void onButtonPress(Player player, int messageId, int value) {
        if (messageId < 0) {
            return;
        }
        if (messageId < 9) {
            this.colors[messageId] = IPneumaticTube.TubeColor.values()[value];
        } else if (messageId == 9) {
            this.pullMode = PullMode.values()[value];
        } else if (messageId == 10) {
            this.sortMode = SortMode.values()[value];
        } else {
            this.fuzzySettings[messageId - 11] = value;
        }
    }

    private boolean matchAndProcessColumn(Container inputInventory, int[] accessibleSlots, int column) {
        ArrayList<ItemStack> requirements = new ArrayList<ItemStack>();
        for (int i = 0; i < 5; ++i) {
            ItemStack filterStack = (ItemStack)this.inventory.get(column + 8 * i);
            if (filterStack.m_41619_()) continue;
            boolean duplicate = false;
            for (ItemStack requirement : requirements) {
                if (!ItemStackHelper.areStacksEqual(requirement, filterStack, this.fuzzySettings[column])) continue;
                requirement.m_41764_(requirement.m_41613_() + filterStack.m_41613_());
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            requirements.add(filterStack.m_41777_());
        }
        if (requirements.size() == 0) {
            return false;
        }
        ItemStack[] copy = new ItemStack[requirements.size()];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = ((ItemStack)requirements.get(i)).m_41777_();
        }
        Iterator iterator = requirements.iterator();
        block3: while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            for (Object slot : (Object)accessibleSlots) {
                ItemStack invStack = inputInventory.m_8020_((int)slot);
                if (invStack.m_41619_() || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                stack.m_41764_(stack.m_41613_() - invStack.m_41613_());
                if (stack.m_41613_() > 0) continue;
                iterator.remove();
                continue block3;
            }
        }
        if (requirements.isEmpty()) {
            for (ItemStack stack : copy) {
                for (int slot : accessibleSlots) {
                    ItemStack invStack;
                    if (stack.m_41613_() <= 0 || (invStack = inputInventory.m_8020_(slot)) == ItemStack.f_41583_ || !ItemStackHelper.areStacksEqual(invStack, stack, this.fuzzySettings[column])) continue;
                    int substracted = Math.min(stack.m_41613_(), invStack.m_41613_());
                    stack.m_41764_(stack.m_41613_() - substracted);
                    invStack.m_41764_(invStack.m_41613_() - substracted);
                    if (invStack.m_41613_() <= 0) {
                        inputInventory.m_6836_(slot, ItemStack.f_41583_);
                    }
                    ItemStack bufferStack = invStack.m_41777_();
                    bufferStack.m_41764_(substracted);
                    this.addItemToOutputBuffer(bufferStack, this.colors[column]);
                }
            }
            inputInventory.m_6596_();
            return true;
        }
        return false;
    }

    private boolean tryProcessItem(ItemStack stack, boolean simulate) {
        switch (this.sortMode) {
            case ANYSTACK_SEQUENTIAL: {
                break;
            }
            case ALLSTACK_SEQUENTIAL: {
                break;
            }
            case RANDOM_ALLSTACKS: {
                break;
            }
            case ANY_ITEM: 
            case ANY_ITEM_DEFAULT: {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    ItemStack filter = (ItemStack)this.inventory.get(i);
                    if (filter.m_41619_() || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8]) || stack.m_41613_() < filter.m_41613_()) continue;
                    if (!simulate) {
                        ItemStack itemStack = stack.m_41777_();
                        itemStack.m_41764_(filter.m_41613_());
                        this.addItemToOutputBuffer(itemStack, this.colors[i % 8]);
                    }
                    stack.m_41764_(stack.m_41613_() - filter.m_41613_());
                    return true;
                }
                if (this.sortMode != SortMode.ANY_ITEM_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.m_41777_(), this.colors[8]);
                }
                stack.m_41764_(0);
                return true;
            }
            case ANY_STACK: 
            case ANY_STACK_DEFAULT: {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    ItemStack filter = (ItemStack)this.inventory.get(i);
                    if (filter.m_41619_() || !ItemStackHelper.areStacksEqual(filter, stack, this.fuzzySettings[i % 8])) continue;
                    if (!simulate) {
                        this.addItemToOutputBuffer(stack.m_41777_(), this.colors[i % 8]);
                    }
                    stack.m_41764_(0);
                    return true;
                }
                if (this.sortMode != SortMode.ANY_STACK_DEFAULT) break;
                if (!simulate) {
                    this.addItemToOutputBuffer(stack.m_41777_(), this.colors[8]);
                }
                stack.m_41764_(0);
                return true;
            }
        }
        return false;
    }

    private void gotoNextNonEmptyColumn() {
        int oldColumn = this.curColumn++;
        if (this.curColumn > 7) {
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        while (oldColumn != this.curColumn) {
            for (int i = this.curColumn; i < this.inventory.size(); i += 8) {
                if (((ItemStack)this.inventory.get(i)).m_41619_()) continue;
                return;
            }
            if (++this.curColumn <= 7) continue;
            this.curColumn = 0;
            this.sweepTriggered = false;
        }
        this.curColumn = 0;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("pullMode", (byte)this.pullMode.ordinal());
        tag.m_128344_("sortMode", (byte)this.sortMode.ordinal());
        tag.m_128405_("savedPulses", this.savedPulses);
        int[] colorArray = new int[this.colors.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = this.colors[i].ordinal();
        }
        tag.m_128385_("colors", colorArray);
        tag.m_128385_("fuzzySettings", this.fuzzySettings);
        ListTag tagList = new ListTag();
        for (int currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            if (((ItemStack)this.inventory.get(currentIndex)).m_41619_()) continue;
            CompoundTag tagCompound = new CompoundTag();
            tagCompound.m_128344_("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).m_41739_(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.m_128365_("Items", (Tag)tagList);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pullMode = PullMode.values()[tag.m_128445_("pullMode")];
        this.sortMode = SortMode.values()[tag.m_128445_("sortMode")];
        this.savedPulses = tag.m_128451_("savedPulses");
        int[] colorArray = tag.m_128465_("colors");
        for (int i = 0; i < colorArray.length; ++i) {
            this.colors[i] = IPneumaticTube.TubeColor.values()[colorArray[i]];
        }
        if (tag.m_128441_("fuzzySettings")) {
            this.fuzzySettings = tag.m_128465_("fuzzySettings");
        }
        ListTag tagList = tag.m_128437_("Items", 10);
        this.inventory = NonNullList.m_122780_((int)40, (Object)ItemStack.f_41583_);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tagCompound = tagList.m_128728_(i);
            byte slot = tagCompound.m_128445_("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)tagCompound));
        }
    }

    public int m_6643_() {
        return this.inventory.size() + 1;
    }

    public boolean m_7983_() {
        return this.inventory.size() == 0;
    }

    public ItemStack m_8020_(int slot) {
        return slot < this.inventory.size() ? (ItemStack)this.inventory.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            this.m_6836_(slot, ItemStack.f_41583_);
        }
        return itemStack;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)itemStack);
            if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
                itemStack.m_41764_(this.m_6893_());
            }
        } else if (!itemStack.m_41619_()) {
            this.tryProcessItem(itemStack, false);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int var1, ItemStack var2) {
        return var1 < this.inventory.size() ? true : !var2.m_41619_() && this.tryProcessItem(var2, true);
    }

    public void m_6211_() {
    }

    public int[] m_7071_(Direction side) {
        return new int[]{this.inventory.size()};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return this.getOutputDirection().m_122424_() == direction && this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public static enum PullMode {
        SINGLE_STEP("single_step"),
        AUTOMATIC("automatic"),
        SINGLE_SWEEP("single_sweep");

        private final String name;

        private PullMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.pullMode." + this.name;
        }
    }

    public static enum SortMode {
        ANYSTACK_SEQUENTIAL("any_stack_sequential"),
        ALLSTACK_SEQUENTIAL("all_stacks_sequential"),
        RANDOM_ALLSTACKS("all_stacks_random"),
        ANY_ITEM("any_item"),
        ANY_ITEM_DEFAULT("any_item_default"),
        ANY_STACK("any_stack"),
        ANY_STACK_DEFAULT("any_stack_default");

        private final String name;

        private SortMode(String name) {
            this.name = name;
        }

        public String toString() {
            return "gui.bluepower:sortingMachine.sortMode." + this.name;
        }
    }
}

