/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.TileMachineBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileTransposer
extends TileMachineBase {
    private static AABB[] ITEM_SUCK_AABBS = new AABB[6];

    public TileTransposer(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.TRANSPOSER.get(), pos, state);
    }

    public static void tickTransposer(Level level, BlockPos pos, BlockState state, TileTransposer tileTransposer) {
        TileBase.tickTileBase(level, pos, state, tileTransposer);
        if (!level.f_46443_) {
            tileTransposer.suckEntity();
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        Direction direction = this.getFacingDirection();
        if (!this.f_58857_.f_46443_ && newValue) {
            if (this.f_58857_.m_46859_(this.f_58858_.m_121945_(direction))) {
                this.suckItems();
            } else {
                this.pullItem();
            }
        }
    }

    protected void pullItem() {
        Direction dir = this.getOutputDirection().m_122424_();
        BlockEntity inputTE = this.getTileCache(dir);
        ItemStack extractedStack = IOHelper.extractOneItem(inputTE, dir.m_122424_());
        if (!extractedStack.m_41619_()) {
            this.addItemToOutputBuffer(extractedStack);
        }
    }

    private void suckItems() {
        for (ItemEntity entity : this.f_58857_.m_45976_(ItemEntity.class, ITEM_SUCK_AABBS[this.getFacingDirection().ordinal()].m_82338_(this.f_58858_))) {
            ItemStack stack = entity.m_32055_();
            if (!this.isItemAccepted(stack) || !entity.m_6084_()) continue;
            this.addItemToOutputBuffer(stack, this.getAcceptedItemColor(stack));
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void suckEntity() {
        Direction direction = this.getFacingDirection();
        AABB box = new AABB((double)(this.f_58858_.m_123341_() + direction.m_122429_()), (double)(this.f_58858_.m_123342_() + direction.m_122430_()), (double)(this.f_58858_.m_123343_() + direction.m_122431_()), (double)(this.f_58858_.m_123341_() + direction.m_122429_() + 1), (double)(this.f_58858_.m_123342_() + direction.m_122430_() + 1), (double)(this.f_58858_.m_123343_() + direction.m_122431_() + 1));
        for (ItemEntity entity : this.f_58857_.m_45976_(ItemEntity.class, box)) {
            ItemStack stack = entity.m_32055_();
            if (!this.isItemAccepted(stack) || !entity.m_6084_()) continue;
            this.addItemToOutputBuffer(stack, this.getAcceptedItemColor(stack));
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected boolean isItemAccepted(ItemStack item) {
        return true;
    }

    protected IPneumaticTube.TubeColor getAcceptedItemColor(ItemStack item) {
        return IPneumaticTube.TubeColor.NONE;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    static {
        TileTransposer.ITEM_SUCK_AABBS[0] = new AABB(-1.0, -1.0, -1.0, 2.0, 0.0, 2.0);
        TileTransposer.ITEM_SUCK_AABBS[1] = new AABB(-1.0, 1.0, -1.0, 2.0, 2.0, 2.0);
        TileTransposer.ITEM_SUCK_AABBS[2] = new AABB(-1.0, -1.0, -1.0, 2.0, 2.0, 0.0);
        TileTransposer.ITEM_SUCK_AABBS[3] = new AABB(-1.0, -1.0, 1.0, 2.0, 2.0, 2.0);
        TileTransposer.ITEM_SUCK_AABBS[4] = new AABB(-1.0, -1.0, -1.0, 0.0, 2.0, 2.0);
        TileTransposer.ITEM_SUCK_AABBS[5] = new AABB(1.0, -1.0, -1.0, 2.0, 2.0, 2.0);
    }
}

