/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.container.ContainerProjectTable;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.tile.TileBase;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileProjectTable
extends TileBase
implements WorldlyContainer,
MenuProvider {
    public static final int SLOTS = 28;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)18, (Object)ItemStack.f_41583_);
    protected NonNullList<ItemStack> craftingGrid = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public TileProjectTable(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.PROJECT_TABLE.get(), pos, state);
    }

    public TileProjectTable(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        for (ItemStack stack : this.craftingGrid) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        CompoundTag tagCompound;
        int currentIndex;
        super.m_183515_(tag);
        ListTag tagList = new ListTag();
        for (currentIndex = 0; currentIndex < this.inventory.size(); ++currentIndex) {
            tagCompound = new CompoundTag();
            tagCompound.m_128344_("Slot", (byte)currentIndex);
            ((ItemStack)this.inventory.get(currentIndex)).m_41739_(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.m_128365_("Items", (Tag)tagList);
        tagList = new ListTag();
        for (currentIndex = 0; currentIndex < this.craftingGrid.size(); ++currentIndex) {
            tagCompound = new CompoundTag();
            tagCompound.m_128344_("Slot", (byte)currentIndex);
            ((ItemStack)this.craftingGrid.get(currentIndex)).m_41739_(tagCompound);
            tagList.add((Object)tagCompound);
        }
        tag.m_128365_("CraftingGrid", (Tag)tagList);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        byte slot;
        CompoundTag tagCompound;
        int i;
        super.m_142466_(tag);
        ListTag tagList = tag.m_128437_("Items", 10);
        this.inventory = NonNullList.m_122780_((int)19, (Object)ItemStack.f_41583_);
        for (i = 0; i < tagList.size(); ++i) {
            tagCompound = tagList.m_128728_(i);
            slot = tagCompound.m_128445_("Slot");
            if (slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)tagCompound));
        }
        tagList = tag.m_128437_("CraftingGrid", 10);
        this.craftingGrid = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        for (i = 0; i < tagList.size(); ++i) {
            tagCompound = tagList.m_128728_(i);
            slot = tagCompound.m_128445_("Slot");
            if (slot < 0 || slot >= this.craftingGrid.size()) continue;
            this.craftingGrid.set((int)slot, (Object)ItemStack.m_41712_((CompoundTag)tagCompound));
        }
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int i) {
        return i < 18 ? (ItemStack)this.inventory.get(i) : (ItemStack)this.craftingGrid.get(i - 18);
    }

    public ItemStack getStackInCraftingSlot(int i) {
        return (ItemStack)this.craftingGrid.get(i);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int i) {
        ItemStack itemStack = this.m_8020_(i);
        if (!itemStack.m_41619_()) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
        return itemStack;
    }

    public void m_6836_(int i, ItemStack itemStack) {
        if (i < 18) {
            this.inventory.set(i, (Object)itemStack);
        } else {
            this.craftingGrid.set(i - 18, (Object)itemStack);
        }
    }

    public void setCraftingSlotContents(int i, ItemStack itemStack) {
        this.craftingGrid.set(i, (Object)itemStack);
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public void m_6211_() {
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"project_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerProjectTable(id, inventory, (Container)this);
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_() - 1).toArray();
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index < this.m_6643_();
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index < this.m_6643_();
    }
}

