/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.block.machine.BlockAlloyFurnace;
import com.bluepowermod.container.ContainerAlloyFurnace;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.init.BPRecipeTypes;
import com.bluepowermod.tile.TileBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileAlloyFurnace
extends TileBase
implements WorldlyContainer,
MenuProvider {
    private boolean isActive;
    private int currentBurnTime;
    private int currentProcessTime;
    private int maxBurnTime;
    public static final int SLOTS = 11;
    private NonNullList<ItemStack> inventory;
    private ItemStack fuelInventory;
    private ItemStack outputInventory;
    private IAlloyFurnaceRecipe currentRecipe;
    private boolean updatingRecipe = true;
    protected final ContainerData fields = new ContainerData(){

        public int m_6413_(int i) {
            switch (i) {
                case 0: {
                    return TileAlloyFurnace.this.currentBurnTime;
                }
                case 1: {
                    return TileAlloyFurnace.this.currentProcessTime;
                }
                case 2: {
                    return TileAlloyFurnace.this.maxBurnTime;
                }
            }
            return 0;
        }

        public void m_8050_(int i, int value) {
            switch (i) {
                case 0: {
                    TileAlloyFurnace.this.currentBurnTime = value;
                    break;
                }
                case 1: {
                    TileAlloyFurnace.this.currentProcessTime = value;
                    break;
                }
                case 2: {
                    TileAlloyFurnace.this.maxBurnTime = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public TileAlloyFurnace(BlockPos pos, BlockState state) {
        super((BlockEntityType)BPBlockEntityType.ALLOY_FURNACE.get(), pos, state);
        this.inventory = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        this.fuelInventory = ItemStack.f_41583_;
        this.outputInventory = ItemStack.f_41583_;
    }

    @Override
    public void m_142466_(CompoundTag tCompound) {
        super.m_142466_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = tCompound.m_128469_("inventory" + i);
            this.inventory.set(i, (Object)ItemStack.m_41712_((CompoundTag)tc));
        }
        this.fuelInventory = ItemStack.m_41712_((CompoundTag)tCompound.m_128469_("fuelInventory"));
        this.outputInventory = ItemStack.m_41712_((CompoundTag)tCompound.m_128469_("outputInventory"));
    }

    @Override
    protected void m_183515_(CompoundTag tCompound) {
        super.m_183515_(tCompound);
        for (int i = 0; i < 9; ++i) {
            CompoundTag tc = new CompoundTag();
            ((ItemStack)this.inventory.get(i)).m_41739_(tc);
            tCompound.m_128365_("inventory" + i, (Tag)tc);
        }
        if (this.fuelInventory != null) {
            CompoundTag fuelCompound = new CompoundTag();
            this.fuelInventory.m_41739_(fuelCompound);
            tCompound.m_128365_("fuelInventory", (Tag)fuelCompound);
        }
        if (this.outputInventory != null) {
            CompoundTag outputCompound = new CompoundTag();
            this.outputInventory.m_41739_(outputCompound);
            tCompound.m_128365_("outputInventory", (Tag)outputCompound);
        }
    }

    @Override
    public void readFromPacketNBT(CompoundTag tag) {
        super.readFromPacketNBT(tag);
        this.isActive = tag.m_128471_("isActive");
        this.currentBurnTime = tag.m_128451_("currentBurnTime");
        this.currentProcessTime = tag.m_128451_("currentProcessTime");
        this.maxBurnTime = tag.m_128451_("maxBurnTime");
        this.markForRenderUpdate();
    }

    @Override
    public void writeToPacketNBT(CompoundTag tag) {
        super.writeToPacketNBT(tag);
        tag.m_128405_("currentBurnTime", this.currentBurnTime);
        tag.m_128405_("currentProcessTime", this.currentProcessTime);
        tag.m_128405_("maxBurnTime", this.maxBurnTime);
        tag.m_128379_("isActive", this.isActive);
    }

    public static void tickAlloyFurnace(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        TileAlloyFurnace tileAlloyFurnace = (TileAlloyFurnace)blockEntity;
        TileBase.tickTileBase(level, pos, state, tileAlloyFurnace);
        if (!level.f_46443_) {
            tileAlloyFurnace.setIsActive(tileAlloyFurnace.currentBurnTime > 0);
            if (tileAlloyFurnace.isActive) {
                --tileAlloyFurnace.currentBurnTime;
            }
            if (tileAlloyFurnace.updatingRecipe) {
                if (level.m_7465_().m_44015_((RecipeType)BPRecipeTypes.ALLOY_SMELTING.get(), (Container)tileAlloyFurnace, level).isPresent()) {
                    tileAlloyFurnace.currentRecipe = (IAlloyFurnaceRecipe)level.m_7465_().m_44015_((RecipeType)BPRecipeTypes.ALLOY_SMELTING.get(), (Container)tileAlloyFurnace, level).get();
                    if (!(tileAlloyFurnace.outputInventory.m_41720_() == tileAlloyFurnace.currentRecipe.m_8043_().m_41720_() && tileAlloyFurnace.outputInventory.m_41613_() + tileAlloyFurnace.currentRecipe.assemble(tileAlloyFurnace.inventory, level.m_7465_()).m_41613_() <= tileAlloyFurnace.outputInventory.m_41741_() || tileAlloyFurnace.outputInventory.m_41619_())) {
                        tileAlloyFurnace.currentRecipe = null;
                    }
                } else {
                    tileAlloyFurnace.currentRecipe = null;
                }
                tileAlloyFurnace.updatingRecipe = false;
            }
            if (tileAlloyFurnace.currentRecipe != null) {
                if (tileAlloyFurnace.currentBurnTime <= 0) {
                    if (FurnaceBlockEntity.m_58423_().containsKey(tileAlloyFurnace.fuelInventory.m_41720_())) {
                        tileAlloyFurnace.currentBurnTime = tileAlloyFurnace.maxBurnTime = ((Integer)FurnaceBlockEntity.m_58423_().get(tileAlloyFurnace.fuelInventory.m_41720_())).intValue();
                        if (!tileAlloyFurnace.fuelInventory.m_41619_()) {
                            tileAlloyFurnace.fuelInventory.m_41764_(tileAlloyFurnace.fuelInventory.m_41613_() - 1);
                            if (tileAlloyFurnace.fuelInventory.m_41613_() <= 0) {
                                tileAlloyFurnace.fuelInventory = tileAlloyFurnace.fuelInventory.m_41720_().getCraftingRemainingItem(tileAlloyFurnace.fuelInventory);
                            }
                        }
                    } else {
                        tileAlloyFurnace.currentProcessTime = 0;
                    }
                }
                if (++tileAlloyFurnace.currentProcessTime >= 200) {
                    tileAlloyFurnace.currentProcessTime = 0;
                    if (!tileAlloyFurnace.outputInventory.m_41619_()) {
                        tileAlloyFurnace.outputInventory.m_41764_(tileAlloyFurnace.outputInventory.m_41613_() + tileAlloyFurnace.currentRecipe.assemble(tileAlloyFurnace.inventory, level.m_7465_()).m_41613_());
                    } else {
                        tileAlloyFurnace.outputInventory = tileAlloyFurnace.currentRecipe.assemble(tileAlloyFurnace.inventory, level.m_7465_()).m_41777_();
                    }
                    tileAlloyFurnace.currentRecipe.useItems(tileAlloyFurnace.inventory, level.m_7465_());
                    tileAlloyFurnace.updatingRecipe = true;
                }
            } else {
                tileAlloyFurnace.currentProcessTime = 0;
            }
        }
    }

    @Override
    protected void redstoneChanged(boolean newValue) {
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean _isActive) {
        if (_isActive != this.isActive) {
            this.isActive = _isActive;
            BlockAlloyFurnace.setState(this.isActive, this.f_58857_, this.f_58858_);
            this.sendUpdatePacket();
        }
    }

    public int m_6643_() {
        return 11;
    }

    public ItemStack m_8020_(int var1) {
        this.updatingRecipe = true;
        if (var1 == 0) {
            return this.fuelInventory;
        }
        if (var1 == 1) {
            return this.outputInventory;
        }
        if (var1 < 11) {
            return (ItemStack)this.inventory.get(var1 - 2);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = this.m_8020_(slot);
        if (!itemStack.m_41619_()) {
            if (itemStack.m_41613_() <= amount) {
                this.m_6836_(slot, ItemStack.f_41583_);
            } else if ((itemStack = itemStack.m_41620_(amount)).m_41613_() == 0) {
                this.m_6836_(slot, ItemStack.f_41583_);
            }
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        return this.m_8020_(index);
    }

    public void m_6836_(int var1, ItemStack itemStack) {
        if (var1 == 0) {
            this.fuelInventory = itemStack;
        } else if (var1 == 1) {
            this.outputInventory = itemStack;
        } else {
            this.inventory.set(var1 - 2, (Object)itemStack);
        }
        this.updatingRecipe = true;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return player.m_20183_().m_123314_((Vec3i)this.f_58858_, 64.0);
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot == 0) {
            return FurnaceBlockEntity.m_58399_((ItemStack)itemStack);
        }
        return slot != 1;
    }

    @Override
    public NonNullList<ItemStack> getDrops() {
        NonNullList<ItemStack> drops = super.getDrops();
        if (!this.fuelInventory.m_41619_()) {
            drops.add((Object)this.fuelInventory);
        }
        if (!this.outputInventory.m_41619_()) {
            drops.add((Object)this.outputInventory);
        }
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            drops.add((Object)stack);
        }
        return drops;
    }

    public int[] m_7071_(Direction side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    public boolean m_7155_(int slot, ItemStack item, Direction direction) {
        return this.m_7013_(slot, item);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction direction) {
        return slot == 1;
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    public void m_6211_() {
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"alloyfurnace");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerAlloyFurnace(id, inventory, (Container)this, this.fields);
    }
}

