/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.init.BPRecipeTypes;
import com.bluepowermod.tile.tier1.TileAlloyFurnace;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AlloyFurnaceRegistry {
    private static AlloyFurnaceRegistry INSTANCE = new AlloyFurnaceRegistry();
    private Map<ItemStack, ItemStack> moltenDownMap = new HashMap<ItemStack, ItemStack>();
    public List<Item> blacklist = new ArrayList<Item>();
    public List<ItemStack> recyclingItems = new ArrayList<ItemStack>();
    public HashMap<Item, ItemStack> recyclingRecipes = new HashMap();

    private AlloyFurnaceRegistry() {
    }

    public static AlloyFurnaceRegistry getInstance() {
        return INSTANCE;
    }

    public ItemStack getRecyclingStack(ItemStack original) {
        ItemStack moltenDownStack = this.moltenDownMap.get(original);
        return moltenDownStack != null ? moltenDownStack : original;
    }

    public static class Serializer
    implements RecipeSerializer<IAlloyFurnaceRecipe> {
        public IAlloyFurnaceRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            NonNullList<Integer> countlist = Serializer.readCount(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for alloy furnace recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new StandardAlloyFurnaceRecipe(recipeId, s, itemstack, nonnulllist, countlist);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray jsonArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        private static NonNullList<Integer> readCount(JsonArray jsonArray) {
            NonNullList countlist = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                int count = jsonArray.get(i).isJsonObject() && ((JsonObject)jsonArray.get(i)).has("count") ? ((JsonObject)jsonArray.get(i)).get("count").getAsInt() : 1;
                if (ingredient.m_43947_()) continue;
                countlist.add(i, (Object)count);
            }
            return countlist;
        }

        @Nullable
        public IAlloyFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int j;
            String s = buffer.m_130136_(Short.MAX_VALUE);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            NonNullList countlist = NonNullList.m_122780_((int)i, (Object)0);
            for (j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            for (j = 0; j < nonnulllist.size(); ++j) {
                countlist.set(j, (Object)buffer.readInt());
            }
            ItemStack itemstack = buffer.m_130267_();
            return new StandardAlloyFurnaceRecipe(recipeId, s, itemstack, (NonNullList<Ingredient>)nonnulllist, (NonNullList<Integer>)countlist);
        }

        public void toNetwork(FriendlyByteBuf buffer, IAlloyFurnaceRecipe recipe) {
            if (recipe instanceof StandardAlloyFurnaceRecipe) {
                buffer.m_130070_(((StandardAlloyFurnaceRecipe)recipe).group);
                buffer.m_130130_(((StandardAlloyFurnaceRecipe)recipe).requiredItems.size());
                for (Ingredient ingredient : ((StandardAlloyFurnaceRecipe)recipe).requiredItems) {
                    ingredient.m_43923_(buffer);
                }
                Iterator iterator = ((StandardAlloyFurnaceRecipe)recipe).requiredCount.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    buffer.writeInt(i);
                }
                buffer.m_130055_(((StandardAlloyFurnaceRecipe)recipe).craftingResult);
            }
        }
    }

    public static class StandardAlloyFurnaceRecipe
    implements IAlloyFurnaceRecipe {
        private final ItemStack craftingResult;
        private final NonNullList<Ingredient> requiredItems;
        private final NonNullList<Integer> requiredCount;
        private final ResourceLocation id;
        private final String group;

        public StandardAlloyFurnaceRecipe(ResourceLocation id, String group, ItemStack craftingResult, NonNullList<Ingredient> requiredItems, NonNullList<Integer> requiredCount) {
            if (craftingResult == null || craftingResult.m_41619_()) {
                throw new IllegalArgumentException("Alloy Furnace crafting result can't be null!");
            }
            if (requiredItems.size() > 9) {
                throw new IllegalArgumentException("There can't be more than 9 crafting ingredients for the Alloy Furnace!");
            }
            for (Ingredient requiredItem : requiredItems) {
                if (!requiredItem.m_43947_()) continue;
                throw new NullPointerException("An Alloy Furnace crafting ingredient can't be null!");
            }
            this.craftingResult = craftingResult;
            this.requiredItems = requiredItems;
            this.requiredCount = requiredCount;
            this.id = id;
            this.group = group;
        }

        public boolean matches(WorldlyContainer inv, Level worldIn) {
            NonNullList input = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            if (inv instanceof TileAlloyFurnace) {
                for (int i = 2; i < 11; ++i) {
                    input.set(i - 2, (Object)inv.m_8020_(i));
                }
            } else {
                for (int i = 1; i < 10; ++i) {
                    input.set(i - 1, (Object)inv.m_8020_(i));
                }
            }
            return this.matches((NonNullList<ItemStack>)input);
        }

        public ItemStack assemble(WorldlyContainer inv) {
            NonNullList input = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            if (inv instanceof TileAlloyFurnace) {
                for (int i = 2; i < 12; ++i) {
                    input.set(i - 2, (Object)inv.m_8020_(i));
                }
            } else {
                for (int i = 1; i < 11; ++i) {
                    input.set(i - 1, (Object)inv.m_8020_(i));
                }
            }
            return this.assemble((NonNullList<ItemStack>)input, null);
        }

        public boolean m_8004_(int width, int height) {
            return width <= 3 && height <= 3;
        }

        public ItemStack m_8043_() {
            return this.craftingResult;
        }

        public ResourceLocation m_6423_() {
            return this.id;
        }

        public String m_6076_() {
            return this.group;
        }

        public ItemStack m_8042_() {
            return new ItemStack((ItemLike)BPBlocks.alloyfurnace.get());
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)BPRecipeSerializer.ALLOYSMELTING.get();
        }

        public RecipeType<?> m_6671_() {
            return (RecipeType)BPRecipeTypes.ALLOY_SMELTING.get();
        }

        @Override
        public boolean matches(NonNullList<ItemStack> input) {
            for (int i = 0; i < this.requiredItems.size(); ++i) {
                int itemsNeeded = (Integer)this.requiredCount.get(i);
                for (ItemStack inputStack : input) {
                    if (!((Ingredient)this.requiredItems.get(i)).test(inputStack) || (itemsNeeded -= inputStack.m_41613_()) > 0) continue;
                    break;
                }
                if (itemsNeeded <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean useItems(NonNullList<ItemStack> input, RecipeManager recipeManager) {
            for (int j = 0; j < this.requiredItems.size(); ++j) {
                int itemsNeeded = (Integer)this.requiredCount.get(j);
                for (int i = 0; i < input.size(); ++i) {
                    ItemStack inputStack = (ItemStack)input.get(i);
                    if (!((Ingredient)this.requiredItems.get(j)).test(inputStack)) continue;
                    int itemsSubstracted = Math.min(inputStack.m_41613_(), itemsNeeded);
                    inputStack.m_41764_(inputStack.m_41613_() - itemsSubstracted);
                    if (inputStack.m_41613_() <= 0) {
                        input.set(i, (Object)ItemStack.f_41583_);
                    }
                    if ((itemsNeeded -= itemsSubstracted) <= 0) break;
                }
                if (itemsNeeded <= 0) continue;
                BluePower.log.error("Alloy Furnace recipe using items, after using still items required?? This is a bug!");
                return false;
            }
            return true;
        }

        @Override
        public ItemStack assemble(NonNullList<ItemStack> input, RecipeManager recipeManager) {
            return this.craftingResult;
        }

        @Override
        public NonNullList<Ingredient> getRequiredItems() {
            return this.requiredItems;
        }

        @Override
        public NonNullList<Integer> getRequiredCount() {
            return this.requiredCount;
        }
    }
}

