/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.container.stack.TubeStack;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerTickTime {
    private double tickTime;

    public MessageServerTickTime(double tickTime) {
        this.tickTime = tickTime;
    }

    public static void handle(MessageServerTickTime msg, Supplier<NetworkEvent.Context> contextSupplier) {
        TubeStack.tickTimeMultiplier = Math.min(1.0, 50.0 / Math.max(msg.tickTime - 5.0, 0.01));
    }

    public static MessageServerTickTime decode(FriendlyByteBuf buffer) {
        double tickTime = buffer.readDouble();
        return new MessageServerTickTime(tickTime);
    }

    public static void encode(MessageServerTickTime message, FriendlyByteBuf buffer) {
        buffer.writeDouble(message.tickTime);
    }
}

