/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.annotation;

import com.bluepowermod.network.annotation.SyncedField;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;

public class PacketCUpdateGui {
    private int syncId;
    private Object value;
    private byte type;

    public PacketCUpdateGui(int syncId, SyncedField syncField) {
        this.syncId = syncId;
        this.value = syncField.getValue();
        this.type = PacketCUpdateGui.getType(syncField);
    }

    public static byte getType(SyncedField syncedField) {
        if (syncedField instanceof SyncedField.SyncedInt) {
            return 0;
        }
        if (syncedField instanceof SyncedField.SyncedFloat) {
            return 1;
        }
        if (syncedField instanceof SyncedField.SyncedDouble) {
            return 2;
        }
        if (syncedField instanceof SyncedField.SyncedBoolean) {
            return 3;
        }
        if (syncedField instanceof SyncedField.SyncedString) {
            return 4;
        }
        if (syncedField instanceof SyncedField.SyncedEnum) {
            return 5;
        }
        if (syncedField instanceof SyncedField.SyncedItemStack) {
            return 6;
        }
        if (syncedField instanceof SyncedField.SyncedFluidTank) {
            return 7;
        }
        throw new IllegalArgumentException("Invalid sync type! " + syncedField);
    }

    public static Object readField(ByteBuf buf, int type) {
        switch (type) {
            case 0: {
                return buf.readInt();
            }
            case 1: {
                return Float.valueOf(buf.readFloat());
            }
            case 2: {
                return buf.readDouble();
            }
            case 3: {
                return buf.readBoolean();
            }
            case 4: 
            case 5: {
                return buf.readByte();
            }
            case 6: 
            case 7: {
                if (buf.readBoolean()) break;
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid sync type! " + type);
    }

    public static void writeField(ByteBuf buf, Object value, int type) {
        switch (type) {
            case 0: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case 1: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case 2: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case 3: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                buf.writeByte((int)((Byte)value).byteValue());
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                buf.writeBoolean(value != null);
                if (value == null) break;
                FluidStack fluidStack = (FluidStack)value;
            }
        }
    }

    public void handleClientSide(Player player) {
        AbstractContainerMenu container = player.f_36096_;
    }

    public void handleServerSide(Player player) {
    }

    public void read(DataInput buffer) throws IOException {
    }

    public void write(DataOutput buffer) throws IOException {
    }
}

