/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.item;

import com.bluepowermod.container.ContainerSeedBag;
import com.bluepowermod.item.ItemBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class ItemSeedBag
extends ItemBase
implements MenuProvider {
    public ItemSeedBag() {
        super(new Item.Properties().m_41487_(1));
    }

    public static ItemStack getSeedType(ItemStack seedBag) {
        ItemStack seed = ItemStack.f_41583_;
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        if (seedBag.m_41782_()) {
            seedBagInvHandler.deserializeNBT(seedBag.m_41783_().m_128469_("inv"));
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack is = seedBagInvHandler.getStackInSlot(i);
            if (is.m_41619_()) continue;
            seed = is;
        }
        return seed;
    }

    public int m_142158_(ItemStack stack) {
        return 1 - this.getItemDamageForDisplay(stack) / 576;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41783_() != null;
    }

    public int getItemDamageForDisplay(ItemStack stack) {
        int items = 0;
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        if (stack.m_41782_()) {
            seedBagInvHandler.deserializeNBT(stack.m_41783_().m_128469_("inv"));
        }
        for (int i = 0; i < 8; ++i) {
            ItemStack is = seedBagInvHandler.getStackInSlot(i);
            if (is.m_41619_()) continue;
            items += is.m_41613_();
        }
        return items;
    }

    public int getMaxDamage(ItemStack stack) {
        return 576;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        if (!world.f_46443_ && player.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(handIn));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level worldIn = context.m_43725_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        ItemStackHandler seedBagInvHandler = new ItemStackHandler(9);
        InteractionHand activeHand = InteractionHand.MAIN_HAND;
        ItemStack seedBag = player.m_21120_(activeHand);
        if (!(seedBag.m_41720_() instanceof ItemSeedBag)) {
            seedBag = player.m_21206_();
            activeHand = InteractionHand.OFF_HAND;
        }
        if (seedBag.m_41782_()) {
            seedBagInvHandler.deserializeNBT(seedBag.m_41783_().m_128469_("inv"));
        }
        ItemStack seed = ItemSeedBag.getSeedType(player.m_21120_(hand));
        Block block = Block.m_49814_((Item)seed.m_41720_());
        if (!seed.m_41619_() && block instanceof IPlantable) {
            IPlantable plant = (IPlantable)block;
            BlockState b = worldIn.m_8055_(pos);
            if (b.m_60734_().canSustainPlant(b, (BlockGetter)worldIn, pos, Direction.UP, plant) && worldIn.m_46859_(pos.m_121945_(Direction.UP))) {
                for (int i = 0; i < 9; ++i) {
                    ItemStack is = seedBagInvHandler.getStackInSlot(i);
                    if (is.m_41619_()) continue;
                    worldIn.m_7731_(pos.m_121945_(Direction.UP), block.m_49966_(), 0);
                    seedBagInvHandler.extractItem(i, 1, false);
                    break;
                }
                if (!seedBag.m_41782_()) {
                    seedBag.m_41751_(new CompoundTag());
                }
                if (seedBag.m_41783_() != null) {
                    seedBag.m_41783_().m_128365_("inv", (Tag)seedBagInvHandler.serializeNBT());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"seed_bag");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerSeedBag(id, inventory);
    }
}

