/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container.inventory;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryItem
extends SimpleContainer {
    private ItemStack item;
    private Player player;
    private boolean reading = false;

    public InventoryItem(Player player, ItemStack item, String name, boolean customName, int size) {
        super(new ItemStack[]{item});
        this.player = player;
        this.item = item;
        if (!this.hasInventory()) {
            this.createInventory();
        }
        this.loadInventory();
    }

    public static InventoryItem getItemInventory(ItemStack is, String name, int size) {
        return InventoryItem.getItemInventory(null, is, name, size);
    }

    public static InventoryItem getItemInventory(Player player, ItemStack is, String name, int size) {
        return new InventoryItem(player, is, name, false, size);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void m_5856_(Player player) {
        this.loadInventory();
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
    }

    public void stopOpen(ItemStack is) {
        this.saveInventory(is);
    }

    private boolean hasInventory() {
        if (this.item.m_41783_() == null) {
            return false;
        }
        return this.item.m_41783_().m_128441_("Inventory");
    }

    private void createInventory() {
        this.writeToNBT();
    }

    protected void writeToNBT() {
        if (this.item.m_41783_() == null) {
            this.item.m_41751_(new CompoundTag());
        }
        ListTag itemList = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            CompoundTag slotEntry = new CompoundTag();
            slotEntry.m_128344_("Slot", (byte)i);
            this.m_8020_(i).m_41739_(slotEntry);
            itemList.add((Object)slotEntry);
        }
        CompoundTag inventory = new CompoundTag();
        inventory.m_128365_("Items", (Tag)itemList);
        this.item.m_41783_().m_128365_("Inventory", (Tag)inventory);
    }

    public void loadInventory() {
        this.readFromNBT();
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.reading) {
            this.saveInventory(ItemStack.f_41583_);
        }
    }

    protected void setNBT(ItemStack is) {
        if (is.m_41619_() && this.player != null) {
            is = this.player.m_21205_();
        }
        if (!is.m_41619_() && is.m_41720_() == this.item.m_41720_()) {
            is.m_41751_(this.item.m_41783_());
        }
    }

    protected void readFromNBT() {
        this.reading = true;
        ListTag itemList = (ListTag)((CompoundTag)this.item.m_41783_().m_128423_("Inventory")).m_128423_("Items");
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundTag slotEntry = itemList.m_128728_(i);
            int j = slotEntry.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.m_6643_()) continue;
            this.m_6836_(j, ItemStack.m_41712_((CompoundTag)slotEntry));
        }
        this.reading = false;
    }

    public void saveInventory(ItemStack is) {
        this.writeToNBT();
        this.setNBT(is);
    }
}

