/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.container;

import com.bluepowermod.client.gui.BPMenuType;
import com.bluepowermod.client.gui.IGuiButtonSensitive;
import com.bluepowermod.container.inventory.InventoryProjectTableCrafting;
import com.bluepowermod.container.slot.SlotProjectTableCrafting;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ContainerProjectTable
extends AbstractContainerMenu
implements IGuiButtonSensitive {
    private final Player player;
    private final CraftingContainer craftingGrid;
    private final ResultContainer craftResult;
    private final Container projectTable;

    public ContainerProjectTable(int windowId, Inventory invPlayer, Container inventory) {
        super((MenuType)BPMenuType.PROJECT_TABLE.get(), windowId);
        int j;
        int i;
        this.projectTable = inventory;
        this.craftResult = new ResultContainer();
        this.craftingGrid = new InventoryProjectTableCrafting(this, this.projectTable, 3, 3);
        this.player = invPlayer.f_35978_;
        this.m_38897_((Slot)new SlotProjectTableCrafting(this.projectTable, this.player, this.craftingGrid, this.craftResult, 0, 127, 34));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.craftingGrid, j + i * 3, 34 + j * 18, 16 + i * 18));
            }
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot(this.projectTable, j + i * 9, 8 + j * 18, 79 + i * 18));
            }
        }
        this.bindPlayerInventory(invPlayer);
        this.m_6199_((Container)this.craftingGrid);
    }

    public ContainerProjectTable(int id, Inventory player) {
        this(id, player, (Container)new SimpleContainer(28));
    }

    protected void bindPlayerInventory(Inventory invPlayer) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)invPlayer, j + i * 9 + 9, 8 + j * 18, 126 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)invPlayer, j, 8 + j * 18, 184));
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        int i;
        boolean clickTypeCrafting = slotId == 0 && ((Slot)this.f_38839_.get(slotId)).m_6657_() && (clickTypeIn.equals((Object)ClickType.PICKUP) || clickTypeIn.equals((Object)ClickType.QUICK_MOVE));
        NonNullList beforeAction = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        if (clickTypeCrafting) {
            for (i = 1; i < 10; ++i) {
                Slot matrixSlot = (Slot)this.f_38839_.get(i);
                ItemStack matrixStack = matrixSlot.m_7993_();
                beforeAction.set(i - 1, (Object)matrixStack);
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
        if (clickTypeCrafting) {
            block1: for (i = 1; i < 10; ++i) {
                ItemStack beforeStack = (ItemStack)beforeAction.get(i - 1);
                Slot matrixSlot = (Slot)this.f_38839_.get(i);
                ItemStack matrixStack = matrixSlot.m_7993_();
                if (matrixStack.m_41613_() != 0 || beforeStack.m_41613_() == 0) continue;
                for (int ptSlot = 10; ptSlot < 28; ++ptSlot) {
                    Slot inventorySlot = (Slot)this.f_38839_.get(ptSlot);
                    ItemStack ptStack = inventorySlot.m_7993_();
                    if (ptStack.m_41720_() != beforeStack.m_41720_() || ptStack.m_41783_() != beforeStack.m_41783_()) continue;
                    ptStack.m_41764_(ptStack.m_41613_() - 1);
                    inventorySlot.m_5852_(ptStack);
                    beforeStack.m_41764_(1);
                    matrixSlot.m_5852_(beforeStack);
                    continue block1;
                }
            }
        }
    }

    protected static void updateCrafting(int id, Level world, Player playerEntity, CraftingContainer craftingInventory, ResultContainer craftResultInventory) {
        if (!world.f_46443_) {
            CraftingRecipe icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)playerEntity;
            ItemStack itemstack = ItemStack.f_41583_;
            Optional optional = world.m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)craftingInventory, world);
            if (optional.isPresent() && craftResultInventory.m_40135_(world, serverplayerentity, (Recipe)(icraftingrecipe = (CraftingRecipe)optional.get()))) {
                itemstack = icraftingrecipe.m_5874_((Container)craftingInventory);
            }
            craftResultInventory.m_6836_(0, itemstack);
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(id, 0, 0, itemstack));
        }
    }

    public void m_6199_(Container inventoryIn) {
        ContainerProjectTable.updateCrafting(this.f_38840_, this.player.m_20193_(), this.player, this.craftingGrid, this.craftResult);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void clearCraftingGrid() {
        for (int i = 1; i < 10; ++i) {
            Slot slot = (Slot)this.f_38839_.get(i);
            if (!slot.m_6657_()) continue;
            this.m_38903_(slot.m_7993_(), 10, 28, false);
            if (slot.m_7993_().m_41613_() > 0) continue;
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn.f_40218_ != this.craftResult && super.m_5882_(stack, slotIn);
    }

    public CraftingContainer getCraftingGrid() {
        return this.craftingGrid;
    }

    public ItemStack m_7648_(Player player, int par2) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(par2);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (0 < par2 && par2 < 10 ? !this.m_38903_(itemstack1, 10, 28, false) : (par2 < 28 ? !this.m_38903_(itemstack1, 28, 64, false) : !this.m_38903_(itemstack1, 10, 28, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                this.m_6199_((Container)this.craftingGrid);
                return ItemStack.f_41583_;
            }
            slot.m_40234_(itemstack, itemstack1);
            ItemStack itemstack2 = this.m_142621_();
            slot.m_142406_(player, itemstack1);
            if (par2 == 0) {
                player.m_36176_(itemstack2, false);
            }
        }
        this.m_6199_((Container)this.craftingGrid);
        return itemstack;
    }

    @Override
    public void onButtonPress(Player player, int messageId, int value) {
        this.clearCraftingGrid();
    }
}

