/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.render;

import com.bluepowermod.block.lighting.BlockLamp;
import com.bluepowermod.client.render.BPRenderTypes;
import com.bluepowermod.client.render.RenderHelper;
import com.bluepowermod.tile.tier1.TileLamp;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderLamp
implements BlockEntityRenderer<TileLamp> {
    public void render(TileLamp te, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int partialTicks, int destroyStage) {
        if (!(te.m_58900_().m_60734_() instanceof BlockLamp)) {
            return;
        }
        BlockState stateLamp = te.m_58900_();
        BlockLamp bLamp = (BlockLamp)stateLamp.m_60734_();
        if (te.m_58904_() == null) {
            return;
        }
        int power = (Integer)stateLamp.m_61143_((Property)BlockLamp.POWER);
        int color = bLamp.getColor(stateLamp, (BlockGetter)te.m_58904_(), te.m_58899_(), 0);
        int redMask = 0xFF0000;
        int greenMask = 65280;
        int blueMask = 255;
        int r = (color & redMask) >> 16;
        int g = (color & greenMask) >> 8;
        int b = color & blueMask;
        AABB box = stateLamp.m_60808_((BlockGetter)te.m_58904_(), te.m_58899_()).m_83215_();
        box = box.equals((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)) ? box.m_82400_(0.05) : box.m_82400_(0.03125);
        boolean[] renderFaces = new boolean[]{true, true, true, true, true, true};
        if (stateLamp.m_60808_((BlockGetter)te.m_58904_(), te.m_58899_()).m_83215_().equals((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))) {
            for (Direction face : Direction.values()) {
                BlockState state = te.m_58904_().m_8055_(te.m_58899_().m_121945_(face.m_122424_()));
                if (!(state.m_60734_() instanceof BlockLamp) || !state.m_60808_((BlockGetter)te.m_58904_(), te.m_58899_()).m_83215_().equals((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)) || (Integer)state.m_61143_((Property)BlockLamp.POWER) <= 0) continue;
                renderFaces[face.m_122411_()] = false;
                double offsetx = (double)face.m_122429_() * 0.05 > 0.0 ? (double)face.m_122429_() * 0.05 : 0.0;
                double offsety = (double)face.m_122430_() * 0.05 > 0.0 ? (double)face.m_122430_() * 0.05 : 0.0;
                double offsetz = (double)face.m_122431_() * 0.05 > 0.0 ? (double)face.m_122431_() * 0.05 : 0.0;
                double toffsetx = (double)face.m_122429_() * 0.05 < 0.0 ? (double)face.m_122429_() * 0.05 : 0.0;
                double toffsety = (double)face.m_122430_() * 0.05 < 0.0 ? (double)face.m_122430_() * 0.05 : 0.0;
                double toffsetz = (double)face.m_122431_() * 0.05 < 0.0 ? (double)face.m_122431_() * 0.05 : 0.0;
                box = new AABB(box.f_82288_ + offsetx, box.f_82289_ + offsety, box.f_82290_ + offsetz, box.f_82291_ + toffsetx, box.f_82292_ + toffsety, box.f_82293_ + toffsetz);
            }
        }
        matrixStack.m_85836_();
        double powerDivision = (double)power / 18.0;
        RenderHelper.drawColoredCube(box, iRenderTypeBuffer.m_6299_(BPRenderTypes.LAMP_GLOW), matrixStack, r, g, b, (int)(powerDivision * 200.0), 200, renderFaces);
        matrixStack.m_85849_();
    }
}

