/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.worldgen;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.init.BPBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;

public class BlockBPGlass
extends StainedGlassBlock {
    private final boolean witherproof;

    public BlockBPGlass(boolean witherproof) {
        super(DyeColor.PURPLE, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(5.0f, witherproof ? 2000.0f : 2.0f).m_60918_(SoundType.f_56744_).m_60955_());
        BPBlocks.blockList.add((Block)this);
        this.witherproof = witherproof;
    }

    public BlockBPGlass() {
        super(DyeColor.LIGHT_GRAY, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(5.0f).m_60918_(SoundType.f_56742_).m_60955_());
        BPBlocks.blockList.add((Block)this);
        this.witherproof = false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        if (this.witherproof) {
            tooltip.add((Component)Component.m_237113_((String)(MinecraftColor.RED.getChatColor() + "Witherproof")));
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (this.witherproof) {
            return !(entity instanceof WitherBoss) && !(entity instanceof WitherSkull) && super.canEntityDestroy(state, world, pos, entity);
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        if (!this.witherproof) {
            super.m_7592_(worldIn, pos, explosionIn);
        }
    }

    public boolean m_6903_(Explosion explosion) {
        return !this.witherproof && super.m_6903_(explosion);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        drops.add(new ItemStack((ItemLike)this));
        return drops;
    }
}

