/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block.lighting;

import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.block.lighting.BlockLampRGB;
import com.bluepowermod.client.render.IBPColoredBlock;
import com.bluepowermod.tile.tier1.TileLamp;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;

public class BlockLamp
extends BlockBase
implements IBPColoredBlock,
EntityBlock {
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)15);
    private final boolean isInverted;
    private final MinecraftColor color;
    private int tick = 0;

    public BlockLamp(boolean isInverted, MinecraftColor color) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56742_).m_60978_(1.0f));
        this.isInverted = isInverted;
        this.color = color;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(isInverted ? 15 : 0)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileLamp(pos, state);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)POWER);
    }

    @Override
    public int getColor(BlockState state, BlockGetter w, BlockPos pos, int tint) {
        return this.color.getHex();
    }

    @Override
    public int getColor(ItemStack stack, int tint) {
        return this.color.getHex();
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return !(world.m_8055_(pos).m_60734_() instanceof BlockLampRGB) && super.canConnectRedstone(state, world, pos, side);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        int redstoneValue = context.m_43725_().m_46755_(context.m_8083_());
        if (this.isInverted) {
            redstoneValue = 15 - redstoneValue;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(redstoneValue));
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        drops.add(new ItemStack((ItemLike)this));
        return drops;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (this.tick <= 1) {
            int redstoneValue = world.m_46755_(pos);
            if (this.isInverted) {
                redstoneValue = 15 - redstoneValue;
            }
            world.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)Integer.valueOf(redstoneValue)), 2);
        }
        ++this.tick;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        super.m_6861_(state, world, pos, blockIn, fromPos, bool);
        int redstoneValue = world.m_46755_(pos);
        if (this.isInverted) {
            redstoneValue = 15 - redstoneValue;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(redstoneValue)), 2);
    }
}

