/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.block.IAdvancedSilkyRemovable;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.tile.TileBase;
import com.bluepowermod.tile.TileMachineBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BlockContainerBase
extends BlockBase
implements IAdvancedSilkyRemovable,
EntityBlock {
    private Class<? extends TileBase> tileEntityClass;
    private boolean isRedstoneEmitter;
    private boolean isSilkyRemoving;

    public BlockContainerBase(Material material, Class<? extends TileBase> tileEntityClass) {
        super(material);
        this.setBlockEntityClass(tileEntityClass);
    }

    public BlockContainerBase(BlockBehaviour.Properties properties, Class<? extends TileBase> tileEntityClass) {
        super(properties);
        this.setBlockEntityClass(tileEntityClass);
    }

    public BlockContainerBase setBlockEntityClass(Class<? extends TileBase> tileEntityClass) {
        this.tileEntityClass = tileEntityClass;
        return this;
    }

    public BlockContainerBase emitsRedstone() {
        this.isRedstoneEmitter = true;
        return this;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        drops.add(new ItemStack((ItemLike)this));
        return drops;
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof TileBase) {
                Containers.m_19010_((Level)worldIn, (BlockPos)pos, ((TileBase)tileentity).getDrops());
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    protected Class<? extends BlockEntity> getBlockEntity() {
        return this.tileEntityClass;
    }

    protected TileBase get(BlockGetter w, BlockPos pos) {
        BlockEntity te = w.m_7702_(pos);
        if (!(te instanceof TileBase)) {
            return null;
        }
        return (TileBase)te;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        try {
            return this.getBlockEntity().getDeclaredConstructor(BlockPos.class, BlockState.class).newInstance(pos, state);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : TileMachineBase::tickMachineBase;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        TileBase tileEntity;
        super.m_6861_(state, world, pos, blockIn, fromPos, bool);
        if (!world.f_46443_ && (tileEntity = this.get((BlockGetter)world, pos)) != null) {
            TileBase.setChanged(world, pos, state, tileEntity);
        }
    }

    public boolean m_7899_(BlockState state) {
        return this.isRedstoneEmitter;
    }

    public int m_6378_(BlockState blockState, BlockGetter par1BlockGetter, BlockPos pos, Direction side) {
        TileBase te = this.get(par1BlockGetter, pos);
        if (te != null) {
            return te.getOutputtingRedstone();
        }
        return 0;
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6047_() && !player.m_21120_(hand).m_41619_() && player.m_21120_(hand).m_41720_() == BPItems.screwdriver.get()) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_()) {
            return InteractionResult.FAIL;
        }
        if (world.m_7702_(pos) instanceof MenuProvider) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)world.m_7702_(pos)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    protected boolean canRotateVertical() {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public boolean preSilkyRemoval(Level world, BlockPos pos) {
        this.isSilkyRemoving = true;
        return true;
    }

    @Override
    public void postSilkyRemoval(Level world, BlockPos pos) {
        this.isSilkyRemoving = false;
    }

    @Override
    public boolean writeSilkyData(Level world, BlockPos pos, CompoundTag tag) {
        world.m_7702_(pos).m_187480_();
        return false;
    }

    @Override
    public void readSilkyData(Level world, BlockPos pos, CompoundTag tag) {
        world.m_7702_(pos).m_142466_(tag);
    }
}

