/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.block;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.block.BlockBPMultipart;
import com.bluepowermod.block.BlockBase;
import com.bluepowermod.tile.TileBPMultipart;
import com.bluepowermod.util.AABBUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;

public class BlockBPCableBase
extends BlockBase
implements IBPPartBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected static final BooleanProperty CONNECTED_FRONT = BooleanProperty.m_61465_((String)"connected_front");
    protected static final BooleanProperty CONNECTED_BACK = BooleanProperty.m_61465_((String)"connected_back");
    protected static final BooleanProperty CONNECTED_LEFT = BooleanProperty.m_61465_((String)"connected_left");
    protected static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.m_61465_((String)"connected_right");
    public static final BooleanProperty JOIN_FRONT = BooleanProperty.m_61465_((String)"join_front");
    public static final BooleanProperty JOIN_BACK = BooleanProperty.m_61465_((String)"join_back");
    public static final BooleanProperty JOIN_LEFT = BooleanProperty.m_61465_((String)"join_left");
    public static final BooleanProperty JOIN_RIGHT = BooleanProperty.m_61465_((String)"join_right");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final VoxelShape[] shapes;

    public BlockBPCableBase(float width, float height) {
        super(Material.f_76279_);
        this.shapes = this.makeShapes(width, height);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)JOIN_BACK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        this.onMultipartReplaced(state, worldIn, pos, newState, isMoving);
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public void onMultipartReplaced(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        FACING.m_6908_().forEach(f -> {
            BlockPos neighborPos = pos.m_121945_(f).m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
            worldIn.m_8055_(neighborPos).m_60690_(worldIn, neighborPos, state.m_60734_(), pos, isMoving);
        });
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        super.m_6402_(worldIn, pos, state, livingEntity, itemStack);
        FACING.m_6908_().forEach(f -> {
            BlockPos neighborPos = pos.m_121945_(f).m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_());
            worldIn.m_8055_(neighborPos).m_60690_(worldIn, neighborPos, state.m_60734_(), pos, false);
        });
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60815_();
    }

    protected Capability<?> getCapability() {
        return null;
    }

    private VoxelShape[] makeShapes(float width, float height) {
        float gap = 0.0f;
        float f = 8.0f - width;
        float f1 = 8.0f + width;
        float f2 = 8.0f - width;
        float f3 = 8.0f + width;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)height, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)gap, (double)0.0, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)gap, (double)f2, (double)f3, (double)height, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)gap, (double)f2, (double)f3, (double)height, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)gap, (double)f2, (double)16.0, (double)height, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5), Block.m_49796_((double)f2, (double)0.0, (double)(-height), (double)f3, (double)height, (double)0.0), Block.m_49796_((double)f2, (double)0.0, (double)(16.0f - height), (double)f3, (double)height, (double)16.0), Block.m_49796_((double)(-height), (double)0.0, (double)f2, (double)0.0, (double)height, (double)f3), Block.m_49796_((double)(16.0f - height), (double)0.0, (double)f2, (double)16.0, (double)height, (double)f3)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shapes = this.shapes[this.getShapeIndex(state)];
        if (((Boolean)state.m_61143_((Property)JOIN_FRONT)).booleanValue()) {
            shapes = Shapes.m_83110_((VoxelShape)shapes, (VoxelShape)this.shapes[16]);
        }
        if (((Boolean)state.m_61143_((Property)JOIN_LEFT)).booleanValue()) {
            shapes = Shapes.m_83110_((VoxelShape)shapes, (VoxelShape)this.shapes[18]);
        }
        return AABBUtils.rotate(shapes, (Direction)state.m_61143_((Property)FACING));
    }

    private int getShapeIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.m_61143_((Property)CONNECTED_FRONT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_BACK)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_LEFT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.WEST);
        }
        if (((Boolean)state.m_61143_((Property)CONNECTED_RIGHT)).booleanValue()) {
            i |= BlockBPCableBase.getMask(Direction.EAST);
        }
        return i;
    }

    private static int getMask(Direction facing) {
        return 1 << facing.m_122416_();
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean bool) {
        BlockEntity te = world.m_7702_(pos);
        BlockState newState = this.getStateForPos(world, pos, (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING))), (Direction)state.m_61143_((Property)FACING));
        if (!(te instanceof TileBPMultipart)) {
            world.m_7731_(pos, newState, 2);
        } else {
            ((TileBPMultipart)te).changeState(state, newState);
        }
        state = newState;
        if (!world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_60815_()) {
            if (te instanceof TileBPMultipart) {
                ((TileBPMultipart)te).removeState(state);
            } else {
                world.m_46961_(pos, true);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, CONNECTED_FRONT, CONNECTED_BACK, CONNECTED_LEFT, CONNECTED_RIGHT, JOIN_FRONT, JOIN_BACK, JOIN_LEFT, JOIN_RIGHT, WATERLOGGED});
    }

    protected boolean canConnect(Level world, BlockPos pos, BlockState state, @Nullable BlockEntity tileEntity, Direction direction) {
        if (tileEntity != null) {
            return tileEntity.getCapability(this.getCapability(), direction).isPresent();
        }
        return false;
    }

    private BlockState getStateForPos(Level world, BlockPos pos, BlockState state, Direction face) {
        ArrayList<Direction> directions = new ArrayList<Direction>(FACING.m_6908_());
        List internal = null;
        boolean connected_left = false;
        boolean connected_right = false;
        boolean connected_front = false;
        boolean connected_back = false;
        boolean join_left = false;
        boolean join_right = false;
        boolean join_front = false;
        boolean join_back = false;
        BlockEntity ownTile = world.m_7702_(pos);
        if (ownTile instanceof TileBPMultipart) {
            directions.removeIf(d -> ((TileBPMultipart)ownTile).isSideBlocked((Capability)this.getCapability(), (Direction)d));
            internal = ((TileBPMultipart)ownTile).getStates().stream().filter(s -> s.m_60734_() == this).map(s -> (Direction)s.m_61143_((Property)FACING)).collect(Collectors.toList());
        }
        directions.removeIf(d -> {
            BlockEntity t = world.m_7702_(pos.m_121945_(d));
            return world.m_8055_(pos.m_121945_(d)).m_60734_() == this && world.m_8055_(pos.m_121945_(d)).m_61143_((Property)FACING) != face || t instanceof TileBPMultipart && ((TileBPMultipart)t).getStates().stream().noneMatch(s -> s.m_61143_((Property)FACING) == face);
        });
        for (Direction d2 : directions) {
            BlockEntity tileEntity = world.m_7702_(pos.m_121945_(d2));
            BlockState dirState = world.m_8055_(pos.m_121945_(d2));
            BlockPos dirPos = pos.m_121945_(d2);
            boolean join = false;
            if (world.m_8055_(pos.m_121945_(d2)).m_60734_() == Blocks.f_50016_) {
                dirState = world.m_8055_(pos.m_121945_(d2).m_121945_(face.m_122424_()));
                dirPos = pos.m_121945_(d2).m_121945_(face.m_122424_());
                if (dirState.m_60734_() == this && dirState.m_61143_((Property)FACING) == d2) {
                    tileEntity = world.m_7702_(pos.m_121945_(d2).m_121945_(face.m_122424_()));
                    join = true;
                } else if (dirState.m_60734_() instanceof BlockBPMultipart) {
                    tileEntity = world.m_7702_(pos.m_121945_(d2).m_121945_(face.m_122424_()));
                    if (tileEntity instanceof TileBPMultipart && ((TileBPMultipart)tileEntity).getStates().stream().filter(s -> s.m_60734_() == this).anyMatch(s -> s.m_61143_((Property)FACING) == d2)) {
                        join = true;
                    } else {
                        tileEntity = null;
                    }
                }
            }
            block0 : switch ((Direction)state.m_61143_((Property)FACING)) {
                case UP: 
                case DOWN: {
                    switch (d2) {
                        case EAST: {
                            connected_right = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_right = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case WEST: {
                            connected_left = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_left = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case NORTH: {
                            connected_front = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_front = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case SOUTH: {
                            connected_back = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_back = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (d2) {
                        case WEST: {
                            connected_right = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_right = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case EAST: {
                            connected_left = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_left = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case UP: {
                            connected_front = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_front = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case DOWN: {
                            connected_back = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_back = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (d2) {
                        case EAST: {
                            connected_right = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_right = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case WEST: {
                            connected_left = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_left = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case UP: {
                            connected_front = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_front = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case DOWN: {
                            connected_back = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_back = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (d2) {
                        case NORTH: {
                            connected_right = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_right = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case SOUTH: {
                            connected_left = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_left = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case UP: {
                            connected_front = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_front = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case DOWN: {
                            connected_back = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_back = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (d2) {
                        case SOUTH: {
                            connected_right = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_right = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case NORTH: {
                            connected_left = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_left = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case UP: {
                            connected_front = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_front = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            break block0;
                        }
                        case DOWN: {
                            connected_back = this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                            join_back = join && this.canConnect(world, dirPos, dirState, tileEntity, d2.m_122424_());
                        }
                    }
                }
            }
        }
        if (internal != null) {
            for (Direction d2 : internal) {
                block37 : switch ((Direction)state.m_61143_((Property)FACING)) {
                    case UP: 
                    case DOWN: {
                        switch (d2) {
                            case EAST: {
                                connected_left = true;
                                break block37;
                            }
                            case WEST: {
                                connected_right = true;
                                break block37;
                            }
                            case NORTH: {
                                connected_back = true;
                                break block37;
                            }
                            case SOUTH: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case NORTH: {
                        switch (d2) {
                            case WEST: {
                                connected_left = true;
                                break block37;
                            }
                            case EAST: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (d2) {
                            case EAST: {
                                connected_left = true;
                                break block37;
                            }
                            case WEST: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (d2) {
                            case NORTH: {
                                connected_left = true;
                                break block37;
                            }
                            case SOUTH: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (d2) {
                            case SOUTH: {
                                connected_left = true;
                                break block37;
                            }
                            case NORTH: {
                                connected_right = true;
                                break block37;
                            }
                            case UP: {
                                connected_back = true;
                                break block37;
                            }
                            case DOWN: {
                                connected_front = true;
                            }
                        }
                    }
                }
            }
        }
        FluidState fluidstate = world.m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connected_left))).m_61124_((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connected_right))).m_61124_((Property)CONNECTED_FRONT, (Comparable)Boolean.valueOf(connected_front))).m_61124_((Property)CONNECTED_BACK, (Comparable)Boolean.valueOf(connected_back))).m_61124_((Property)JOIN_LEFT, (Comparable)Boolean.valueOf(join_left))).m_61124_((Property)JOIN_RIGHT, (Comparable)Boolean.valueOf(join_right))).m_61124_((Property)JOIN_FRONT, (Comparable)Boolean.valueOf(join_front))).m_61124_((Property)JOIN_BACK, (Comparable)Boolean.valueOf(join_back))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPos(context.m_43725_(), context.m_8083_(), (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_()), context.m_43719_());
    }

    @Override
    public VoxelShape getOcclusionShape(BlockState state) {
        return AABBUtils.rotate(this.shapes[this.getShapeIndex(state)], (Direction)state.m_61143_((Property)FACING));
    }
}

