/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.api.misc;

public enum MinecraftColor {
    WHITE(0xEBEBEB, 0xF0F0F0, 0xFFFFFF, 'f'),
    ORANGE(13399095, 15435844, 16228709, '6'),
    MAGENTA(11551162, 12801229, 14645736, '1'),
    LIGHT_BLUE(5075908, 6719955, 10862322, 'b'),
    YELLOW(12234014, 14602026, 16443695, 'w'),
    LIME(3913776, 4312372, 9433222, 'a'),
    PINK(11561083, 14188952, 15250369, 'd'),
    GRAY(0x2B2B2B, 0x434343, 0x575757, '8'),
    LIGHT_GRAY(0xFFFFFF, 0xABABAB, 0xFFFFFF, '7'),
    CYAN(1662072, 2651799, 4622499, '3'),
    PURPLE(5840271, 8073150, 10248401, '5'),
    BLUE(1515891, 2437522, 3425215, '1'),
    BROWN(3021583, 5320730, 6502427, '4'),
    GREEN(2437903, 3887386, 5732390, '2'),
    RED(8857894, 11743532, 14695992, 'c'),
    BLACK(263172, 0x1E1B1B, 0x2B2B2B, '0'),
    NONE(-1, -1, -1, '\u0000'),
    ANY(-1, -1, -1, '\u0000');

    public static MinecraftColor[] VALID_COLORS;
    public static MinecraftColor[] WIRE_COLORS;
    private int hexDark;
    private int hex;
    private int hexLight;
    private char chatColorChar;

    private MinecraftColor(int hexDark, int hex, int hexLight, char chatColorChar) {
        this.hexDark = hexDark;
        this.hex = hex;
        this.hexLight = hexLight;
        this.chatColorChar = chatColorChar;
    }

    public int getHexDark() {
        return this.hexDark;
    }

    public int getHex() {
        return this.hex;
    }

    public int getHexLight() {
        return this.hexLight;
    }

    public String getChatColor() {
        return String.valueOf('\u00a7') + this.chatColorChar;
    }

    public char getChatColorChar() {
        return this.chatColorChar;
    }

    public boolean matches(MinecraftColor color) {
        if (this == ANY || color == ANY) {
            return true;
        }
        return this == color;
    }

    public boolean canConnect(MinecraftColor color) {
        if (this == ANY || color == ANY || this == NONE || color == NONE) {
            return true;
        }
        return this == color;
    }

    public String toString() {
        return this.getChatColor();
    }

    static {
        VALID_COLORS = new MinecraftColor[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
        WIRE_COLORS = new MinecraftColor[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK, NONE};
    }
}

