/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod;

import com.bluepowermod.BluePowerAPI;
import com.bluepowermod.ClientProxy;
import com.bluepowermod.CommonProxy;
import com.bluepowermod.api.BPApi;
import com.bluepowermod.api.power.CapabilityBlutricity;
import com.bluepowermod.api.wire.redstone.CapabilityRedstoneDevice;
import com.bluepowermod.client.gui.BPMenuType;
import com.bluepowermod.compat.CompatibilityUtils;
import com.bluepowermod.event.BPEventHandler;
import com.bluepowermod.event.BPRecyclingReloadListener;
import com.bluepowermod.init.BPBlockEntityType;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.BPConfig;
import com.bluepowermod.init.BPEnchantments;
import com.bluepowermod.init.BPItems;
import com.bluepowermod.init.BPRecipeSerializer;
import com.bluepowermod.init.BPRecipeTypes;
import com.bluepowermod.init.Recipes;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.world.BPWorldGen;
import com.bluepowermod.world.WorldGenFlowers;
import com.bluepowermod.world.WorldGenOres;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bluepower")
public class BluePower {
    public static BluePower instance;
    public static CommonProxy proxy;
    public static Logger log;

    public BluePower() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BPConfig.spec);
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::complete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        BPBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPBlockEntityType.BLOCK_ENTITY_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPEnchantments.ENCHANTMENT.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPRecipeTypes.RECIPE_TYPE.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPRecipeSerializer.RECIPE_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPWorldGen.FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        BPMenuType.MENU_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(BPEnchantments.class);
        BPEventHandler eventHandler = new BPEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        BPApi.init(new BluePowerAPI());
        proxy.preInitRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenOres());
        MinecraftForge.EVENT_BUS.register((Object)new WorldGenFlowers());
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(BPNetworkHandler::init);
        event.enqueueWork(BPWorldGen::registerFeatures);
        event.enqueueWork(WorldGenOres::registerOres);
        event.enqueueWork(WorldGenFlowers::registerFlowers);
        proxy.setup(event);
        CompatibilityUtils.init(event);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        CapabilityBlutricity.register(event);
        CapabilityRedstoneDevice.register(event);
    }

    public void complete(FMLLoadCompleteEvent event) {
        event.enqueueWork(proxy::initRenderers);
        CompatibilityUtils.postInit(event);
        Recipes.init();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new BPRecyclingReloadListener(event.getServerResources()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerStart(ServerStartedEvent event) {
        BPRecyclingReloadListener.onResourceManagerReload(event.getServer().m_129894_().m_44013_(RecipeType.f_44107_));
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        ResourceLocation grass = new ResourceLocation("minecraft", "blocks/tall_grass");
        if (event.getName().equals((Object)grass)) {
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("bluepower", "blocks/tall_grass"))).name("bluepower:tall_grass").m_79082_());
        }
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        log = LogManager.getLogger((String)"bluepower");
    }
}

