/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.serialization;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

@Deprecated(forRemoval=true)
public class StringEntryReader<T> {
    private final Registry<T> activeRegistry;

    protected StringEntryReader(Registry<T> registry) {
        this.activeRegistry = registry;
    }

    protected final List<T> getEntriesFromRegistry(String source) {
        return StringEntryReader.getEntriesFromRegistry(source, this.activeRegistry);
    }

    public static <R> List<R> getEntriesFromRegistry(String source, Registry<R> activeRegistry) {
        ArrayList foundEntries = Lists.newArrayList();
        if (source.contains("*")) {
            foundEntries.addAll(StringEntryReader.getWildcardEntries(source, activeRegistry));
        } else {
            Optional<ResourceLocation> location = Optional.ofNullable(ResourceLocation.m_135820_((String)source));
            if (location.isPresent()) {
                Optional<R> entry = StringEntryReader.getEntryFromRegistry(location.get(), activeRegistry);
                entry.ifPresent(foundEntries::add);
            } else {
                StringEntryReader.log(source, "Entry not found");
            }
        }
        return foundEntries;
    }

    private static <R> Optional<R> getEntryFromRegistry(ResourceLocation location, Registry<R> activeRegistry) {
        if (activeRegistry.m_7804_(location)) {
            return Optional.ofNullable(activeRegistry.m_7745_(location));
        }
        StringEntryReader.log(location.toString(), "Entry not found");
        return Optional.empty();
    }

    private static <R> List<R> getWildcardEntries(String source, Registry<R> activeRegistry) {
        String[] splitSource = source.split(":");
        switch (splitSource.length) {
            case 1: {
                return StringEntryReader.getListFromRegistry("minecraft", splitSource[0], activeRegistry);
            }
            case 2: {
                return StringEntryReader.getListFromRegistry(splitSource[0], splitSource[1], activeRegistry);
            }
        }
        StringEntryReader.log(source, "Invalid resource location format");
        return Lists.newArrayList();
    }

    private static <R> List<R> getListFromRegistry(String namespace, String path, Registry<R> activeRegistry) {
        String regexPath = path.replace("*", "[a-z0-9/._-]*");
        List entries = activeRegistry.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(namespace)).filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135815_().matches(regexPath)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (entries.isEmpty()) {
            StringEntryReader.log(new ResourceLocation(namespace, path).toString(), "Entry not found");
        }
        return entries;
    }

    protected final boolean isNotPresent(Collection<T> collection, T entry) {
        if (collection.contains(entry)) {
            StringEntryReader.log(entry.getClass().getSimpleName(), "Already present");
            return false;
        }
        return true;
    }

    protected static void log(String entry, String message) {
        PuzzlesLib.LOGGER.warn("Unable to parse entry {}: {}", (Object)entry, (Object)message);
    }
}

