/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.capability;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.capability.data.CapabilityComponent;
import fuzs.puzzleslib.capability.data.CapabilityFactory;
import fuzs.puzzleslib.capability.data.CapabilityKey;
import fuzs.puzzleslib.capability.data.PlayerCapabilityKey;
import fuzs.puzzleslib.capability.data.PlayerRespawnStrategy;
import fuzs.puzzleslib.capability.data.SyncStrategy;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface CapabilityController {
    public static final Map<ResourceLocation, CapabilityKey<?>> CAPABILITY_KEY_REGISTRY = Maps.newConcurrentMap();

    public static <T extends CapabilityComponent> void submit(CapabilityKey<T> capabilityKey) {
        if (CAPABILITY_KEY_REGISTRY.put(capabilityKey.getId(), capabilityKey) != null) {
            throw new IllegalStateException("Duplicate capability %s".formatted(capabilityKey.getId()));
        }
    }

    public static CapabilityKey<?> retrieve(ResourceLocation id) {
        CapabilityKey<?> capabilityKey = CAPABILITY_KEY_REGISTRY.get(id);
        if (capabilityKey != null) {
            return capabilityKey;
        }
        throw new IllegalStateException("No capability registered for id %s".formatted(id));
    }

    default public <C extends CapabilityComponent> CapabilityKey<C> registerItemCapability(String capabilityKey, Class<C> capabilityType, CapabilityFactory<C> capabilityFactory, Item item) {
        return this.registerItemCapability(capabilityKey, capabilityType, capabilityFactory, (Item o) -> o == item);
    }

    public <C extends CapabilityComponent> CapabilityKey<C> registerItemCapability(String var1, Class<C> var2, CapabilityFactory<C> var3, Predicate<Item> var4);

    public <T extends Entity, C extends CapabilityComponent> CapabilityKey<C> registerEntityCapability(String var1, Class<C> var2, CapabilityFactory<C> var3, Class<T> var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, CapabilityFactory<C> var3, PlayerRespawnStrategy var4);

    public <C extends CapabilityComponent> PlayerCapabilityKey<C> registerPlayerCapability(String var1, Class<C> var2, CapabilityFactory<C> var3, PlayerRespawnStrategy var4, SyncStrategy var5);

    public <T extends BlockEntity, C extends CapabilityComponent> CapabilityKey<C> registerBlockEntityCapability(String var1, Class<C> var2, CapabilityFactory<C> var3, Class<T> var4);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelChunkCapability(String var1, Class<C> var2, CapabilityFactory<C> var3);

    public <C extends CapabilityComponent> CapabilityKey<C> registerLevelCapability(String var1, Class<C> var2, CapabilityFactory<C> var3);
}

