/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.BiomeKeys;
import twilightforest.init.TFLandmark;
import twilightforest.util.Vec2i;
import twilightforest.util.XZQuadrantIterator;

public class LegacyLandmarkPlacements {
    private static final Map<ResourceLocation, TFLandmark> BIOME_FEATURES = new ImmutableMap.Builder().put((Object)BiomeKeys.ENCHANTED_FOREST.m_135782_(), (Object)TFLandmark.QUEST_GROVE).put((Object)BiomeKeys.LAKE.m_135782_(), (Object)TFLandmark.QUEST_ISLAND).put((Object)BiomeKeys.SWAMP.m_135782_(), (Object)TFLandmark.LABYRINTH).put((Object)BiomeKeys.FIRE_SWAMP.m_135782_(), (Object)TFLandmark.HYDRA_LAIR).put((Object)BiomeKeys.DARK_FOREST.m_135782_(), (Object)TFLandmark.KNIGHT_STRONGHOLD).put((Object)BiomeKeys.DARK_FOREST_CENTER.m_135782_(), (Object)TFLandmark.DARK_TOWER).put((Object)BiomeKeys.SNOWY_FOREST.m_135782_(), (Object)TFLandmark.YETI_CAVE).put((Object)BiomeKeys.GLACIER.m_135782_(), (Object)TFLandmark.ICE_TOWER).put((Object)BiomeKeys.HIGHLANDS.m_135782_(), (Object)TFLandmark.TROLL_CAVE).put((Object)BiomeKeys.FINAL_PLATEAU.m_135782_(), (Object)TFLandmark.FINAL_CASTLE).build();

    public static TFLandmark getLandmarkDirectlyAt(int chunkX, int chunkZ, WorldGenLevel world) {
        if (LegacyLandmarkPlacements.blockIsInLandmarkCenter(chunkX << 4, chunkZ << 4)) {
            return LegacyLandmarkPlacements.pickLandmarkAtBlock(chunkX << 4, chunkZ << 4, world);
        }
        return TFLandmark.NOTHING;
    }

    public static boolean blockIsInLandmarkCenter(int blockX, int blockZ) {
        return LegacyLandmarkPlacements.chunkHasLandmarkCenter(blockX >> 4, blockZ >> 4);
    }

    public static boolean chunkHasLandmarkCenter(ChunkPos chunkPos) {
        return LegacyLandmarkPlacements.chunkHasLandmarkCenter(chunkPos.f_45578_, chunkPos.f_45579_);
    }

    public static boolean chunkHasLandmarkCenter(int chunkX, int chunkZ) {
        BlockPos nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        return chunkX == nearestCenter.m_123341_() >> 4 && chunkZ == nearestCenter.m_123343_() >> 4;
    }

    public static float distanceFromCenter(BlockPos posXZ, boolean euclidean) {
        BlockPos nearestCenter = LegacyLandmarkPlacements.getNearestCenterXZ(posXZ.m_123341_() >> 4, posXZ.m_123343_() >> 4);
        float dX = posXZ.m_123341_() - nearestCenter.m_123341_();
        float dZ = posXZ.m_123343_() - nearestCenter.m_123343_();
        if (euclidean) {
            return Mth.m_14116_((float)(dX * dX + dZ * dZ));
        }
        return Mth.m_14154_((float)dX) + Mth.m_14154_((float)dZ);
    }

    public static TFLandmark pickLandmarkAtBlock(int blockX, int blockZ, WorldGenLevel world) {
        return LegacyLandmarkPlacements.pickLandmarkForChunk(blockX >> 4, blockZ >> 4, world);
    }

    public static TFLandmark pickLandmarkForChunk(int chunkX, int chunkZ, WorldGenLevel world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        Biome biomeAt = (Biome)world.m_204166_(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8)).m_203334_();
        return LegacyLandmarkPlacements.pickBiomeLandmarkLegacy(world.m_5962_(), chunkX, chunkZ, biomeAt, world.m_7328_());
    }

    public static TFLandmark pickBiomeLandmarkLegacy(RegistryAccess access, int chunkX, int chunkZ, Biome biome, long seed) {
        TFLandmark biomeFeature;
        Optional registryOpt = access.m_6632_(Registry.f_122885_);
        if (registryOpt.isPresent() && (biomeFeature = BIOME_FEATURES.get(((Registry)registryOpt.get()).m_7981_((Object)biome))) != null) {
            return biomeFeature;
        }
        return LegacyLandmarkPlacements.pickVarietyLandmark(chunkX, chunkZ, seed);
    }

    public static TFLandmark pickVarietyLandmark(int chunkX, int chunkZ, long seed) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return TFLandmark.LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return TFLandmark.NAGA_COURTYARD;
        }
        return switch (new Random(seed + (long)chunkX * 25117L + (long)chunkZ * 151121L).nextInt(16)) {
            case 6, 7, 8 -> TFLandmark.MEDIUM_HILL;
            case 9 -> TFLandmark.LARGE_HILL;
            case 10, 11 -> TFLandmark.HEDGE_MAZE;
            case 12, 13 -> TFLandmark.NAGA_COURTYARD;
            case 14, 15 -> TFLandmark.LICH_TOWER;
            default -> TFLandmark.SMALL_HILL;
        };
    }

    public static TFLandmark getNearestLandmark(int cx, int cz, WorldGenLevel world) {
        return LegacyLandmarkPlacements.getNearestLandmark(cx, cz, world, null);
    }

    public static TFLandmark getNearestLandmark(int cx, int cz, WorldGenLevel world, @Nullable Vec2i center) {
        int maxSize = TFLandmark.getMaxSearchSize();
        int diam = maxSize * 2 + 1;
        TFLandmark[] features = new TFLandmark[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFLandmark directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = LegacyLandmarkPlacements.getLandmarkDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return TFLandmark.NOTHING;
    }

    public static TFLandmark getFeatureForRegion(int chunkX, int chunkZ, WorldGenLevel world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return LegacyLandmarkPlacements.pickLandmarkForChunk(featureX, featureZ, world);
    }

    public static TFLandmark getFeatureForRegionPos(int posX, int posZ, WorldGenLevel world) {
        return LegacyLandmarkPlacements.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static XZQuadrantIterator<BlockPos> landmarkCenterScanner(BlockPos searchFocus, int gridSearchRadius) {
        return new XZQuadrantIterator<BlockPos>(searchFocus.m_123341_() >> 4 & 0xFFFFFFF0, searchFocus.m_123343_() >> 4 & 0xFFFFFFF0, false, gridSearchRadius, 16, LegacyLandmarkPlacements::getNearestCenterXZ);
    }

    public static BlockPos getNearestCenterXZ(int chunkX, int chunkZ) {
        return LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ, 0);
    }

    public static BlockPos getNearestCenterXZ(int chunkX, int chunkZ, int height) {
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, height, ccz);
    }

    public static boolean isTheseFeatures(TFLandmark feature, TFLandmark ... predicates) {
        for (TFLandmark predicate : predicates) {
            if (feature != predicate) continue;
            return true;
        }
        return false;
    }
}

