/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.entity.village;

import com.google.common.collect.ImmutableSet;
import dev.architectury.registry.level.entity.trade.SimpleTrade;
import dev.architectury.registry.level.entity.trade.TradeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.entity.village.IMPPoiType;
import dev.felnull.imp.item.IMPItems;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.util.OERegisterUtils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class IMPVillagerProfessions {
    private static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((String)"iammusicplayer", (ResourceKey)Registry.f_122809_);
    public static final RegistrySupplier<VillagerProfession> DJ = IMPVillagerProfessions.register("dj", IMPPoiType.DJ, SoundEvents.f_12028_);

    private static RegistrySupplier<VillagerProfession> register(String name, Supplier<PoiType> poiType, SoundEvent soundEvent) {
        return VILLAGER_PROFESSIONS.register(name, () -> new VillagerProfession(new ResourceLocation("iammusicplayer", name).toString(), arg_0 -> IMPVillagerProfessions.lambda$register$0((Supplier)poiType, arg_0), arg_0 -> IMPVillagerProfessions.lambda$register$1((Supplier)poiType, arg_0), ImmutableSet.of(), ImmutableSet.of(), soundEvent));
    }

    public static void init() {
        VILLAGER_PROFESSIONS.register();
    }

    public static void setup() {
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 1, (ItemLike)IMPItems.CASSETTE_TAPE.get(), 1, 1, 10, 2);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 1, (ItemLike)IMPItems.CASSETTE_TAPE_GLASS.get(), 1, 1, 10, 2);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 2, (ItemLike)IMPBlocks.MUSIC_MANAGER.get(), 18, 1, 1, 12);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 3, (ItemLike)IMPBlocks.CASSETTE_DECK.get(), 13, 1, 1, 12);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 4, (ItemLike)IMPBlocks.BOOMBOX.get(), 15, 1, 3, 12);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 5, (ItemLike)IMPItems.RADIO_ANTENNA.get(), 15, 1, 1, 23);
        IMPVillagerProfessions.registerBuying((VillagerProfession)DJ.get(), 5, (ItemLike)IMPItems.PARABOLIC_ANTENNA.get(), 33, 1, 1, 23);
        IMPVillagerProfessions.registerSelling((VillagerProfession)DJ.get(), 1, (ItemLike)Items.f_42576_, 12, 15, 2);
        IMPVillagerProfessions.registerSelling((VillagerProfession)DJ.get(), 2, (ItemLike)Items.f_41859_, 8, 10, 13);
        IMPVillagerProfessions.registerSelling((VillagerProfession)DJ.get(), 2, (ItemLike)Items.f_42451_, 12, 15, 2);
        IMPVillagerProfessions.registerSelling((VillagerProfession)DJ.get(), 3, (ItemLike)Items.f_41984_, 1, 5, 20);
        TradeRegistry.registerTradeForWanderingTrader((boolean)true, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{new SimpleTrade(new ItemStack((ItemLike)Items.f_42616_, 42), ItemStack.f_41583_, IMPItemUtil.createKamesutaAntenna(), 1, 10, 0.05f)});
    }

    public static void registerBuying(VillagerProfession profession, int level, ItemLike item, int emeraldCost, int numberOfItems, int maxUses, int villagerXp) {
        TradeRegistry.registerVillagerTrade((VillagerProfession)profession, (int)level, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{OERegisterUtils.createTradeItemsForEmeralds((ItemStack)new ItemStack(item), (int)emeraldCost, (int)numberOfItems, (int)maxUses, (int)villagerXp)});
    }

    public static void registerSelling(VillagerProfession profession, int level, ItemLike item, int cost, int maxUses, int villagerXp) {
        TradeRegistry.registerVillagerTrade((VillagerProfession)profession, (int)level, (VillagerTrades.ItemListing[])new VillagerTrades.ItemListing[]{OERegisterUtils.createTradeEmeraldForItems((ItemLike)item, (int)cost, (int)maxUses, (int)villagerXp)});
    }

    private static /* synthetic */ boolean lambda$register$1(Supplier poiType, Holder holder) {
        return ((PoiType)holder.m_203334_()).equals(poiType.get());
    }

    private static /* synthetic */ boolean lambda$register$0(Supplier poiType, Holder holder) {
        return ((PoiType)holder.m_203334_()).equals(poiType.get());
    }
}

