/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.felnull.imp.api.client.MusicSpeakerAccess;
import dev.felnull.imp.client.music.AudioInfo;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.player.MusicInstantaneous;
import dev.felnull.imp.client.music.player.MusicLoadChunk;
import dev.felnull.imp.client.music.player.MusicPlayer;
import dev.felnull.imp.client.music.speaker.MusicBuffer;
import dev.felnull.imp.client.music.speaker.MusicSpeaker;
import dev.felnull.imp.client.util.MusicUtils;
import dev.felnull.imp.include.dev.felnull.fnjl.concurrent.InvokeExecutor;
import dev.felnull.imp.music.MusicSpeakerFixedInfo;
import dev.felnull.imp.music.resource.MusicSource;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sound.sampled.AudioInputStream;
import org.lwjgl.BufferUtils;

public abstract class BaseMusicPlayer
implements MusicPlayer<LoadInput, LoadResult> {
    private final InvokeExecutor tickExecutor = new InvokeExecutor();
    private final Map<UUID, MusicSpeaker> speakers = new HashMap<UUID, MusicSpeaker>();
    private final Map<UUID, MusicSpeaker> preSpeakers = new HashMap<UUID, MusicSpeaker>();
    private final List<ReadEntry> readEntries = new ArrayList<ReadEntry>();
    private final Map<Long, ReadWait> waits = new HashMap<Long, ReadWait>();
    private final AudioInfo audioInfo;
    private final MusicSource musicSource;
    private final int aheadLoad;
    private final Object readLock = new Object();
    private final AtomicBoolean readStreamEnd = new AtomicBoolean();
    private final UUID musicPlayerId;
    private boolean destroy;
    private boolean loaded;
    private boolean playing;
    private boolean pause;
    private boolean reading;
    private boolean finished;
    private boolean loadEnd;
    private long delay;
    private long startPosition = -1L;
    private long startTime = -1L;
    private long pauseTime = -1L;
    private long totalPauseTime;
    private long totalReadTime;
    private AudioInputStream stream;

    protected BaseMusicPlayer(UUID musicPlayerId, AudioInfo audioInfo, MusicSource musicSource, int aheadLoad) {
        this.audioInfo = audioInfo;
        this.musicSource = musicSource;
        this.aheadLoad = aheadLoad;
        this.musicPlayerId = musicPlayerId;
    }

    @Override
    public List<MusicSpeaker> getSpeakerList() {
        ImmutableList.Builder speakerBuilder = new ImmutableList.Builder();
        speakerBuilder.addAll(this.speakers.values());
        speakerBuilder.addAll(this.preSpeakers.values());
        return speakerBuilder.build();
    }

    @Override
    public void play(long delay) {
        this.delay = delay;
        this.startTime = System.currentTimeMillis();
        this.playing = true;
        if (this.pause) {
            this.pauseTime = System.currentTimeMillis();
        }
        for (MusicSpeaker value : this.speakers.values()) {
            this.speakerUpdate(value);
        }
        for (UUID uuid : this.preSpeakers.keySet()) {
            this.updatePreSpeaker(uuid);
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.destroy) {
            return;
        }
        this.destroy = true;
        this.playing = false;
        this.stopReadStream();
        CompletableFuture.runAsync(() -> {
            try {
                this.closeAudioStream();
                Object object = this.readLock;
                synchronized (object) {
                    if (this.stream != null) {
                        this.stream.close();
                    }
                }
            }
            catch (Exception e) {
                MusicEngine.getInstance().getLogger().error("Failed to close music stream", (Throwable)e);
            }
        }, MusicEngine.getInstance().getMusicAsyncExecutor());
        for (MusicSpeaker value : this.speakers.values()) {
            value.destroy();
        }
        for (MusicSpeaker value : this.preSpeakers.values()) {
            value.destroy();
        }
        for (ReadEntry readEntry : this.readEntries) {
            for (MusicBuffer value : readEntry.buffers.values()) {
                if (!value.canRelease()) continue;
                value.release();
            }
        }
    }

    @Override
    public boolean isDestroy() {
        return this.destroy;
    }

    @Override
    public void pause() {
        if (this.playing) {
            this.pauseTime = System.currentTimeMillis();
        }
        this.pause = true;
        for (MusicSpeaker value : this.speakers.values()) {
            value.pause();
        }
        for (MusicSpeaker value : this.preSpeakers.values()) {
            value.pause();
        }
        if (this.musicSource.isLive()) {
            this.finished = true;
        }
    }

    @Override
    public void resume() {
        if (this.playing) {
            this.totalPauseTime += System.currentTimeMillis() - this.pauseTime;
            this.pauseTime = -1L;
        }
        this.pause = false;
        for (MusicSpeaker value : this.speakers.values()) {
            value.resume();
        }
        for (MusicSpeaker value : this.preSpeakers.values()) {
            value.resume();
        }
    }

    @Override
    public void tick() {
        MusicUtils.runInvokeTasks(this.tickExecutor, "Music Player");
        if (!this.loaded) {
            return;
        }
        ArrayList delSpeakers = new ArrayList();
        this.speakers.forEach((id, speaker) -> {
            if (speaker.isDead()) {
                try {
                    speaker.destroy();
                }
                catch (Exception e) {
                    MusicEngine.getInstance().getLogger().error("Failed to destroy speaker", (Throwable)e);
                }
                delSpeakers.add(id);
                return;
            }
            speaker.tick();
            this.speakerUpdate((MusicSpeaker)speaker);
            speaker.releaseBuffers();
        });
        for (ReadEntry readEntry : this.readEntries) {
            if (readEntry.position() >= this.getPosition()) continue;
            ArrayList<MusicSpeakerFixedInfo> dels = new ArrayList<MusicSpeakerFixedInfo>();
            for (Map.Entry<MusicSpeakerFixedInfo, MusicBuffer> entry : readEntry.buffers.entrySet()) {
                if (!entry.getValue().canRelease()) continue;
                entry.getValue().release();
                dels.add(entry.getKey());
            }
            for (MusicSpeakerFixedInfo del : dels) {
                readEntry.buffers.remove(del);
            }
        }
        for (UUID delSpeaker : delSpeakers) {
            this.preSpeakers.put(delSpeaker, new MusicSpeaker(this.musicPlayerId, delSpeaker, this.speakers.get(delSpeaker).getTracker()));
            this.speakers.remove(delSpeaker);
        }
        ArrayList<ReadEntry> delREs = new ArrayList<ReadEntry>();
        for (ReadEntry readEntry : this.readEntries) {
            if (!readEntry.buffers.isEmpty()) continue;
            delREs.add(readEntry);
        }
        this.readEntries.removeAll(delREs);
        this.readTick();
    }

    private void readTick() {
        int lc = this.readEntries.size();
        if (lc == 0 && this.isPlaying()) {
            this.finished = true;
            return;
        }
        int nc = this.musicSource.isLive() ? this.aheadLoad : (int)((float)(this.musicSource.getDuration() - this.getPosition()) / 1000.0f + 0.5f);
        if (!(this.finished || this.loadEnd || this.reading || lc > this.aheadLoad && nc - this.aheadLoad > this.aheadLoad)) {
            CompletionStage cf = CompletableFuture.supplyAsync(() -> this.readStart(this.aheadLoad), this.tickExecutor).thenApplyAsync(ret -> {
                try {
                    return this.readAsync((ReadInput)ret);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, (Executor)MusicEngine.getInstance().getMusicAsyncExecutor());
            ((CompletableFuture)cf).whenCompleteAsync((ret, error) -> {
                if (ret != null && error == null) {
                    this.readApply((ReadResult)ret);
                    return;
                }
                MusicEngine.getInstance().getLogger().error("Failed to read audio data", error);
            }, (Executor)this.tickExecutor);
        }
    }

    private void updatePreSpeaker(UUID uuid) {
        if (this.pause) {
            return;
        }
        MusicSpeaker sp = this.preSpeakers.get(uuid);
        if (sp == null) {
            return;
        }
        List<ReadEntry> r = this.readEntries.stream().filter(readEntry -> readEntry.position() >= this.getPosition()).sorted((o1, o2) -> (int)(o1.position() - o2.position())).toList();
        if (r.stream().allMatch(n -> n.buffers.containsKey(sp.getFixedInfo()))) {
            long min = Long.MAX_VALUE;
            for (ReadEntry readEntry2 : r) {
                min = Math.min(min, readEntry2.position());
                sp.insertBuffer(readEntry2.buffers.get(sp.getFixedInfo()));
            }
            sp.setScheduledStartTime(min - this.getPosition());
            this.preSpeakers.remove(uuid);
            this.speakers.put(uuid, sp);
        } else {
            List<ReadEntry> noLoaded = r.stream().filter(n -> !n.buffers.containsKey(sp.getFixedInfo())).toList();
            for (ReadEntry readEntry3 : noLoaded) {
                ReadWait rw = new ReadWait(readEntry3, sp.getFixedInfo());
                if (this.waits.containsKey(readEntry3.position)) continue;
                MiddleLoadInput mli = this.middleLoadStart(rw);
                CompletableFuture<MiddleLoadResult> cf = CompletableFuture.supplyAsync(() -> this.middleLoadAsync(mli), MusicEngine.getInstance().getMusicAsyncExecutor());
                cf.whenCompleteAsync((ret, error) -> {
                    if (ret != null && error == null) {
                        this.middleLoadApply((MiddleLoadResult)ret);
                        return;
                    }
                    MusicEngine.getInstance().getLogger().error("Failed to middle load audio data", error);
                }, (Executor)this.tickExecutor);
            }
        }
    }

    private void speakerUpdate(MusicSpeaker speaker) {
        if (!this.pause && this.playing && !speaker.isPlaying() && speaker.canPlay()) {
            speaker.play(0L);
        }
    }

    @Override
    public void addSpeaker(UUID speakerId, MusicSpeaker speaker) {
        this.preSpeakers.put(speakerId, speaker);
        if (this.loaded) {
            this.updatePreSpeaker(speakerId);
        }
    }

    @Override
    public void removeSpeaker(UUID uuid) {
        MusicSpeaker sp = this.speakers.remove(uuid);
        if (sp == null) {
            sp = this.preSpeakers.remove(uuid);
        }
        if (sp != null) {
            try {
                sp.destroy();
            }
            catch (Exception e) {
                MusicEngine.getInstance().getLogger().error("Failed to destroy speaker", (Throwable)e);
            }
        }
    }

    @Override
    public boolean existSpeaker(UUID uuid) {
        if (this.speakers.containsKey(uuid)) {
            return true;
        }
        return this.preSpeakers.containsKey(uuid);
    }

    @Override
    public MusicSpeaker getSpeaker(UUID uuid) {
        MusicSpeaker sp = this.speakers.get(uuid);
        if (sp == null) {
            sp = this.preSpeakers.get(uuid);
        }
        return sp;
    }

    @Override
    public int getSpeakerCount() {
        return this.speakers.size() + this.preSpeakers.size();
    }

    @Override
    public LoadInput loadStart(long position) {
        this.startPosition = position;
        return new LoadInput(position, (Map<UUID, MusicSpeaker>)ImmutableMap.copyOf(this.preSpeakers), this.aheadLoad, this.musicSource.isLive());
    }

    protected abstract AudioInputStream openAudioStream(long var1) throws Exception;

    protected abstract void closeAudioStream() throws Exception;

    @Override
    public LoadResult loadAsync(LoadInput input) throws Exception {
        AudioInputStream stream = this.openAudioStream(input.position);
        ReadInput readInput = new ReadInput(stream, input.position, input.aheadLoad, input.speakers.values().stream().map(MusicSpeaker::getFixedInfo).distinct().toList(), this.getAudioInfo());
        ReadResult readRet = this.readAsync(readInput);
        if (input.live()) {
            Thread.sleep(3000L);
        }
        return new LoadResult(stream, readRet, input.speakers.keySet().stream().toList());
    }

    @Override
    public void loadApply(LoadResult loadedData) {
        this.loaded = true;
        this.stream = loadedData.stream;
        List<UUID> spks = loadedData.speakers;
        for (UUID spk : spks) {
            MusicSpeaker sp = this.preSpeakers.remove(spk);
            if (sp == null) continue;
            this.speakers.put(spk, sp);
        }
        ReadResult rd = loadedData.readResults;
        this.readApply(rd);
    }

    @Override
    public float getCurrentAudioWave(int channel) {
        for (ReadEntry readEntry : this.readEntries) {
            long ed = readEntry.instantaneous().sampleTime();
            long st = ed - 1000L;
            if (this.getPosition() < st || this.getPosition() >= ed) continue;
            long rp = this.getPosition() - st;
            int fp = (int)((float)rp / 1000.0f * 60.0f);
            return readEntry.instantaneous().getWaves(channel)[fp];
        }
        return 0.0f;
    }

    @Override
    public long getPosition() {
        if (this.startTime < 0L) {
            return this.startPosition + this.delay;
        }
        long pt = this.totalPauseTime;
        if (this.pauseTime >= 0L) {
            pt += System.currentTimeMillis() - this.pauseTime;
        }
        return System.currentTimeMillis() - this.startTime - pt + this.startPosition + this.delay;
    }

    @Override
    public AudioInfo getAudioInfo() {
        return this.audioInfo;
    }

    @Override
    public boolean waitDestroy() {
        return this.finished || !this.musicSource.isLive() && this.getPosition() >= this.musicSource.getDuration();
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean isPause() {
        return this.pause;
    }

    @Override
    public Map<UUID, MusicSpeakerAccess> getSpeakers() {
        ImmutableMap.Builder speakersBuilder = ImmutableMap.builder();
        speakersBuilder.putAll(this.speakers);
        speakersBuilder.putAll(this.preSpeakers);
        return speakersBuilder.build();
    }

    private ReadInput readStart(int loadCount) {
        this.reading = true;
        ArrayList<MusicSpeakerFixedInfo> infos = new ArrayList<MusicSpeakerFixedInfo>();
        infos.addAll(this.speakers.values().stream().map(MusicSpeaker::getFixedInfo).distinct().toList());
        infos.addAll(this.preSpeakers.values().stream().map(MusicSpeaker::getFixedInfo).distinct().toList());
        return new ReadInput(this.stream, this.totalReadTime + this.startPosition, loadCount, infos.stream().distinct().toList(), this.getAudioInfo());
    }

    protected void stopReadStream() {
        this.readStreamEnd.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readStream(AudioInputStream stream, byte[] buffer) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            try {
                if (stream.read(buffer) < 0) {
                    return false;
                }
            }
            catch (InterruptedIOException ex) {
                return false;
            }
        }
        return !this.readStreamEnd.get();
    }

    private ReadResult readAsync(ReadInput input) throws Exception {
        int ol = input.audioInfo().sampleRate() * input.audioInfo().channel() * (input.audioInfo().bit() / 8);
        byte[] buffer = new byte[ol];
        ArrayList<ReadResultEntry> entries = new ArrayList<ReadResultEntry>();
        long st = input.readStartPosition();
        boolean end = false;
        for (int i = 0; i < input.aheadLoad() && !this.isDestroy(); ++i) {
            if (!this.musicSource.isLive() && st + 1000L > this.musicSource.getDuration()) {
                Arrays.fill(buffer, (byte)0);
            }
            end = !this.readStream(input.stream, buffer);
            byte[] data = (byte[])buffer.clone();
            MusicInstantaneous mi = MusicInstantaneous.create(st, data, input.audioInfo().channel(), input.audioInfo.bit());
            HashMap<MusicSpeakerFixedInfo, BufferFactory> buffes = new HashMap<MusicSpeakerFixedInfo, BufferFactory>();
            for (MusicSpeakerFixedInfo fixedInfo : input.fixedInfos()) {
                buffes.put(fixedInfo, BufferFactory.create(data, fixedInfo, input.audioInfo()));
            }
            entries.add(new ReadResultEntry(st, data, mi, buffes));
            st += 1000L;
            if (end) break;
        }
        return new ReadResult(entries, end);
    }

    private void readApply(ReadResult readResult) {
        if (readResult.end()) {
            this.loadEnd = true;
        }
        this.totalReadTime += (long)readResult.readEntries().size() * 1000L;
        for (ReadResultEntry readEntry : readResult.readEntries()) {
            ReadEntry re = readEntry.create();
            this.readEntries.add(re);
            re.buffers().forEach(this::insertBuffer);
        }
        this.reading = false;
        for (UUID uuid : this.preSpeakers.keySet()) {
            this.updatePreSpeaker(uuid);
        }
    }

    private void insertBuffer(MusicSpeakerFixedInfo info, MusicBuffer buffer) {
        for (MusicSpeaker value : this.speakers.values()) {
            if (!value.isDead() && value.getFixedInfo().equals(info)) {
                value.insertBuffer(buffer);
            }
            this.speakerUpdate(value);
        }
    }

    private MiddleLoadInput middleLoadStart(ReadWait readWait) {
        this.waits.put(readWait.readEntry.position, readWait);
        return new MiddleLoadInput(readWait, this.getAudioInfo());
    }

    private MiddleLoadResult middleLoadAsync(MiddleLoadInput input) {
        byte[] data = input.readWaiter().readEntry().data();
        return new MiddleLoadResult(input.readWaiter(), BufferFactory.create(data, input.readWaiter().fixedInfo(), input.audioInfo()));
    }

    private void middleLoadApply(MiddleLoadResult result) {
        if (result.readWaiter.readEntry.position() < this.getPosition()) {
            return;
        }
        result.readWaiter.readEntry().buffers.put(result.readWaiter.fixedInfo, result.bufferFactory().create());
        this.waits.remove(result.readWaiter.readEntry.position);
        for (UUID uuid : this.preSpeakers.keySet()) {
            this.updatePreSpeaker(uuid);
        }
    }

    @Override
    public int getTaskCount() {
        return this.tickExecutor.getTaskCount();
    }

    @Override
    public long getMaxWaitTime() {
        return (long)this.aheadLoad * 1000L;
    }

    @Override
    public List<MusicLoadChunk> getLoadChunks() {
        return this.readEntries.stream().map(n -> new MusicLoadChunk(n.position(), 1000L)).toList();
    }

    private record ReadEntry(long position, byte[] data, MusicInstantaneous instantaneous, Map<MusicSpeakerFixedInfo, MusicBuffer> buffers) {
    }

    private record ReadWait(ReadEntry readEntry, MusicSpeakerFixedInfo fixedInfo) {
    }

    private record MiddleLoadInput(ReadWait readWaiter, AudioInfo audioInfo) {
    }

    public record LoadInput(long position, Map<UUID, MusicSpeaker> speakers, int aheadLoad, boolean live) {
    }

    private record ReadInput(AudioInputStream stream, long readStartPosition, int aheadLoad, List<MusicSpeakerFixedInfo> fixedInfos, AudioInfo audioInfo) {
    }

    private record ReadResult(List<ReadResultEntry> readEntries, boolean end) {
    }

    public record LoadResult(AudioInputStream stream, ReadResult readResults, List<UUID> speakers) {
    }

    private record BufferFactory(ByteBuffer buffer, boolean relative, AudioInfo audioData) {
        private BufferFactory(byte[] data, boolean relative, AudioInfo audioData) {
            this(BufferFactory.getBuffer(data), relative, audioData);
        }

        private static BufferFactory create(byte[] data, MusicSpeakerFixedInfo fixedInfo, AudioInfo audioInfo) {
            if (MusicUtils.isSpatial(fixedInfo.spatialType()) && fixedInfo.channel() <= -1 && audioInfo.channel() >= 2) {
                data = BufferFactory.synthesisChannel(data, audioInfo);
                audioInfo = new AudioInfo(1, audioInfo.sampleRate(), audioInfo.bit());
            } else if (fixedInfo.channel() >= 0 && audioInfo.channel() >= 2) {
                data = BufferFactory.extractChannel(data, fixedInfo.channel(), audioInfo);
                audioInfo = new AudioInfo(1, audioInfo.sampleRate(), audioInfo.bit());
            }
            return new BufferFactory(data, !MusicUtils.isSpatial(fixedInfo.spatialType()), audioInfo);
        }

        private static byte[] synthesisChannel(byte[] data, AudioInfo audioInfo) {
            if (audioInfo.bit() != 16) {
                throw new RuntimeException("Unsupported bit");
            }
            byte[] ndata = new byte[data.length / audioInfo.channel()];
            for (int i = 0; i < data.length / 2 / audioInfo.channel(); ++i) {
                float total = 0.0f;
                for (int j = 0; j < audioInfo.channel(); ++j) {
                    int l1 = i * 2 * audioInfo.channel() + 2 * j;
                    int l2 = l1 + 1;
                    byte[] d = new byte[]{data[l1], data[l2]};
                    short r = ByteBuffer.wrap(d).order(ByteOrder.LITTLE_ENDIAN).getShort();
                    float val = (float)r / 32767.0f;
                    total += val;
                }
                byte[] ns = BufferFactory.shortToByteArray((short)(32767.0f * (total / (float)audioInfo.channel())));
                int n1 = i * 2;
                int n2 = i * 2 + 1;
                ndata[n1] = ns[0];
                ndata[n2] = ns[1];
            }
            return ndata;
        }

        private static byte[] shortToByteArray(short val) {
            ByteBuffer buffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(val);
            return buffer.array();
        }

        private static byte[] extractChannel(byte[] data, int channel, AudioInfo audioInfo) {
            if (audioInfo.bit() != 16) {
                throw new RuntimeException("Unsupported bit");
            }
            byte[] ndata = new byte[data.length / audioInfo.channel()];
            for (int i = 0; i < data.length / 2 / audioInfo.channel(); ++i) {
                int l1 = i * 2 * audioInfo.channel() + 2 * channel;
                int l2 = l1 + 1;
                int n1 = i * 2;
                int n2 = i * 2 + 1;
                ndata[n1] = data[l1];
                ndata[n2] = data[l2];
            }
            return ndata;
        }

        private static ByteBuffer getBuffer(byte[] array) {
            ByteBuffer audioBuffer2 = BufferUtils.createByteBuffer((int)array.length);
            audioBuffer2.put(array);
            audioBuffer2.flip();
            return audioBuffer2;
        }

        private MusicBuffer create() {
            return new MusicBuffer(this.buffer, this.relative, this.audioData);
        }
    }

    private record ReadResultEntry(long position, byte[] data, MusicInstantaneous instantaneous, Map<MusicSpeakerFixedInfo, BufferFactory> buffers) {
        private ReadEntry create() {
            HashMap<MusicSpeakerFixedInfo, MusicBuffer> rb = new HashMap<MusicSpeakerFixedInfo, MusicBuffer>();
            this.buffers.forEach((fixedInfo, bufferFactory) -> rb.put((MusicSpeakerFixedInfo)fixedInfo, bufferFactory.create()));
            return new ReadEntry(this.position, this.data, this.instantaneous, rb);
        }
    }

    private record MiddleLoadResult(ReadWait readWaiter, BufferFactory bufferFactory) {
    }
}

