/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.api.event.FlightRefreshEvent;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateFlight;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class RitualFlight
extends AbstractRitual {
    @Override
    protected void tick() {
        if (!this.getWorld().f_46443_ && this.getWorld().m_46467_() % 20L == 0L) {
            RitualFlightHandler.activePositions.add(this.getPos());
        }
    }

    @Override
    public int getSourceCost() {
        return 200;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("ars_nouveau", RitualLib.FLIGHT);
    }

    @Override
    public String getLangDescription() {
        return "Grants nearby players the Flight effect when they jump, allowing them to creatively fly for a short time. If the player is nearby, this ritual will refresh their flight buff. Each time this ritual grants or refreshes flight, it will expend source from nearby jars.";
    }

    @Override
    public String getLangName() {
        return "Flight";
    }

    @Mod.EventBusSubscriber(modid="ars_nouveau")
    public static class RitualFlightHandler {
        public static Set<BlockPos> activePositions = new HashSet<BlockPos>();

        @Nullable
        public static RitualFlight getFlightRitual(Level world, BlockPos pos) {
            if (!world.m_46749_(pos)) {
                return null;
            }
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof RitualBrazierTile) {
                RitualBrazierTile tile = (RitualBrazierTile)entity;
                AbstractRitual abstractRitual = tile.ritual;
                if (abstractRitual instanceof RitualFlight) {
                    RitualFlight ritualFlight = (RitualFlight)abstractRitual;
                    return ritualFlight;
                }
            }
            return null;
        }

        public static void grantFlight(LivingEntity entity) {
            BlockPos pos = RitualFlightHandler.getValidPosition(entity.f_19853_, entity.m_20183_());
            if (pos == null || !entity.f_19853_.m_46749_(pos)) {
                return;
            }
            BlockEntity tileEntity = entity.f_19853_.m_7702_(pos);
            if (tileEntity instanceof RitualBrazierTile) {
                RitualBrazierTile tile = (RitualBrazierTile)tileEntity;
                AbstractRitual abstractRitual = tile.ritual;
                if (abstractRitual instanceof RitualFlight) {
                    RitualFlight ritualFlight = (RitualFlight)abstractRitual;
                    tile.ritual.setNeedsSource(true);
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModPotions.FLIGHT_EFFECT.get(), 1800));
                }
            }
        }

        public static BlockPos getValidPosition(Level world, BlockPos fromPos) {
            ArrayList<BlockPos> stalePositions = new ArrayList<BlockPos>();
            BlockPos foundPos = null;
            for (BlockPos p : activePositions) {
                if (!world.m_46749_(p) || !(BlockUtil.distanceFrom(p, fromPos) <= 60.0)) continue;
                RitualFlight ritualFlight = RitualFlightHandler.getFlightRitual(world, p);
                if (ritualFlight == null) {
                    stalePositions.add(p);
                    continue;
                }
                if (ritualFlight.needsSourceNow()) continue;
                foundPos = p;
                break;
            }
            stalePositions.forEach(activePositions::remove);
            return foundPos;
        }

        @Nullable
        public static BlockPos canPlayerStillFly(LivingEntity entity) {
            return RitualFlightHandler.getValidPosition(entity.f_19853_, entity.m_20183_());
        }

        @SubscribeEvent
        public static void refreshFlight(FlightRefreshEvent e) {
            if (!e.getEntity().f_19853_.f_46443_) {
                BlockPos validPos = RitualFlightHandler.canPlayerStillFly((LivingEntity)e.getEntity());
                boolean wasFlying = e.getEntity().f_36077_.f_35935_;
                if (validPos != null && wasFlying) {
                    e.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModPotions.FLIGHT_EFFECT.get(), 1200));
                    e.getEntity().f_36077_.f_35936_ = true;
                    e.getEntity().f_36077_.f_35935_ = wasFlying;
                    Networking.sendToPlayer(new PacketUpdateFlight(true, wasFlying), (ServerPlayer)e.getEntity());
                    BlockEntity tile = e.getEntity().f_19853_.m_7702_(validPos);
                    if (tile instanceof RitualBrazierTile && ((RitualBrazierTile)tile).ritual instanceof RitualFlight) {
                        ((RitualBrazierTile)tile).ritual.setNeedsSource(true);
                    }
                }
            }
        }
    }
}

