/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.item;

import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleLineData;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.client.renderer.item.FixedGeoItemRenderer;
import com.hollingsworth.arsnouveau.client.renderer.item.SpellCrossbowModel;
import com.hollingsworth.arsnouveau.common.items.SpellCrossbow;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.core.util.Color;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoBone;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;

public class SpellCrossbowRenderer
extends FixedGeoItemRenderer<SpellCrossbow> {
    public SpellCrossbowRenderer() {
        super((AnimatedGeoModel)new SpellCrossbowModel());
    }

    @Override
    public void renderRecursively(GeoBone bone, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("gem")) {
            super.renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        } else {
            super.renderRecursively(bone, poseStack, buffer, packedLight, packedOverlay, (float)Color.WHITE.getRed() / 255.0f, (float)Color.WHITE.getGreen() / 255.0f, (float)Color.WHITE.getBlue() / 255.0f, (float)Color.WHITE.getAlpha() / 255.0f);
        }
    }

    @Override
    public void m_108829_(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int p_239207_6_) {
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && !Minecraft.m_91087_().m_91104_()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Vec3 playerPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 look = player.m_20154_();
            Vec3 right = new Vec3(-look.f_82481_, 0.0, look.f_82479_).m_82541_();
            Vec3 forward = look;
            Vec3 down = right.m_82537_(forward);
            int timeHeld = 72000 - Minecraft.m_91087_().f_91074_.m_21212_();
            if (timeHeld > 72000) {
                right = right.m_82490_(0.1 - (double)player.f_20921_);
                forward = forward.m_82490_(0.25);
                down = down.m_82490_(-0.1 - (double)player.f_20921_);
            } else if (SpellCrossbow.m_40932_((ItemStack)itemStack)) {
                right = right.m_82490_(-0.05 - (double)player.f_20921_);
                forward = forward.m_82490_((double)0.35f);
                down = down.m_82490_(-0.2 - (double)player.f_20921_);
            } else {
                right = right.m_82490_((double)(-player.f_20921_));
                forward = forward.m_82490_((double)0.45f);
                down = down.m_82490_(-0.3 - (double)player.f_20921_);
            }
            Vec3 laserPos = playerPos.m_82549_(right);
            laserPos = laserPos.m_82549_(forward);
            laserPos = laserPos.m_82549_(down);
            ISpellCaster tool = CasterUtil.getCaster(itemStack);
            if (timeHeld > 0 && timeHeld != 72000 || SpellCrossbow.m_40932_((ItemStack)itemStack)) {
                float scaleAge = (float)ParticleUtil.inRange(0.05, 0.1);
                if (player.f_19853_.f_46441_.m_188503_(6) == 0) {
                    for (int i = 0; i < 1; ++i) {
                        Vec3 particlePos = new Vec3(laserPos.f_82479_, laserPos.f_82480_, laserPos.f_82481_);
                        particlePos = particlePos.m_82549_(ParticleUtil.pointInSphere().m_82490_((double)0.3f));
                        player.f_19853_.m_7106_(ParticleLineData.createData(tool.getColor(), scaleAge, 5 + player.f_19853_.f_46441_.m_188503_(20)), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), laserPos.m_7096_(), laserPos.m_7098_(), laserPos.m_7094_());
                    }
                }
            }
        }
        super.m_108829_(itemStack, transformType, stack, bufferIn, combinedLightIn, p_239207_6_);
    }

    @Override
    public void render(GeoModel model, Object animatable, float partialTicks, RenderType type, PoseStack matrixStackIn, @javax.annotation.Nullable MultiBufferSource renderTypeBuffer, @javax.annotation.Nullable VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        IBone right = model.getBone("bow_right").get();
        IBone gem = model.getBone("gem").get();
        IBone left = model.getBone("bow_left").get();
        float outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 10.0f % 360.0f;
        Item item = this.currentItemStack.m_41720_();
        if (item instanceof SpellCrossbow) {
            SpellCrossbow spellCrossbow = (SpellCrossbow)item;
            int timeHeld = (int)((float)(72000 - Minecraft.m_91087_().f_91074_.m_21212_()) + partialTicks);
            if (SpellCrossbow.m_40932_((ItemStack)this.currentItemStack)) {
                right.setRotationY((float)((double)right.getRotationY() - Math.toRadians(35.0)));
                left.setRotationY((float)((double)left.getRotationY() + Math.toRadians(35.0)));
                outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 3.0f % 360.0f;
            } else if (timeHeld != 0 && timeHeld != 72000 && Minecraft.m_91087_().f_91074_.m_21205_().equals(this.currentItemStack)) {
                int offset = 40;
                timeHeld = Math.min(timeHeld, 72000);
                right.setRotationY((float)((double)right.getRotationY() - Math.toRadians(30.0) - Math.toRadians(timeHeld)));
                left.setRotationY((float)((double)left.getRotationY() + Math.toRadians(30.0) + Math.toRadians(timeHeld)));
                outerAngle = ((float)ClientInfo.ticksInGame + partialTicks) / 5.0f % 360.0f;
            }
        }
        gem.setRotationX(outerAngle);
        gem.setRotationY(outerAngle);
        super.render(model, animatable, partialTicks, type, matrixStackIn, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public Color getRenderColor(Object animatable, float partialTick, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight) {
        ParticleColor color = ParticleColor.defaultParticleColor();
        if (this.currentItemStack.m_41782_()) {
            color = ((SpellCrossbow)animatable).getSpellCaster(this.currentItemStack).getColor();
        }
        return Color.ofRGBA(color.toWrapper().r, color.toWrapper().g, color.toWrapper().b, 200);
    }

    @Override
    public RenderType getRenderType(Object animatable, float partialTicks, PoseStack stack, @javax.annotation.Nullable MultiBufferSource renderTypeBuffer, @javax.annotation.Nullable VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }
}

