/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell.wrapped_caster;

import com.hollingsworth.arsnouveau.api.item.inv.FilterableItemHandler;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class TileCaster
implements IWrappedCaster {
    protected SpellContext.CasterType casterType;
    protected List<FilterableItemHandler> handlers;
    protected BlockEntity tile;

    public TileCaster(BlockEntity tile, SpellContext.CasterType casterType) {
        this.tile = tile;
        this.casterType = casterType;
        this.handlers = new ArrayList<FilterableItemHandler>();
        this.initFilterables(tile);
    }

    public void initFilterables(BlockEntity tile) {
        this.handlers = new ArrayList<FilterableItemHandler>(InvUtil.adjacentInventories(tile.m_58904_(), tile.m_58899_()));
    }

    @Override
    @NotNull
    public List<FilterableItemHandler> getInventory() {
        return this.handlers;
    }

    @Override
    public SpellContext.CasterType getCasterType() {
        return this.casterType;
    }

    public BlockEntity getTile() {
        return this.tile;
    }

    @Override
    public Direction getFacingDirection() {
        if (this.tile.m_58900_().m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (Direction)this.tile.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        }
        return Direction.NORTH;
    }
}

