/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.util.StackWithChance;

public class MachineProcessingResult {
    public static final MachineProcessingResult NONE = new MachineProcessingResult(){

        @Override
        public boolean exists() {
            return false;
        }
    };
    public final StackWithChance output;
    public final StackWithChance[] extra;
    public final double time;
    public final int[] consume;

    private MachineProcessingResult() {
        this.output = StackWithChance.EMPTY;
        this.extra = new StackWithChance[0];
        this.time = 1.0;
        this.consume = new int[0];
    }

    public MachineProcessingResult(MachineRecipe recipe) {
        this.output = recipe.outputItems.get(0);
        if (recipe.outputItems.size() > 1) {
            this.extra = new StackWithChance[recipe.outputItems.size() - 1];
            for (int i = 1; i < recipe.outputItems.size(); ++i) {
                this.extra[i - 1] = recipe.outputItems.get(i);
            }
        } else {
            this.extra = MachineProcessingResult.NONE.extra;
        }
        this.time = recipe.processingTime;
        this.consume = new int[recipe.inputItems.size()];
    }

    public boolean exists() {
        return true;
    }
}

