/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.treeharvester_common_forge.events.TreeEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeTreeEvent {
    @SubscribeEvent
    public void onServerStart(ServerStartedEvent e) {
        TreeEvent.setupBlacklist();
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        TreeEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        TreeEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public void onTreeHarvest(BlockEvent.BreakEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        TreeEvent.onTreeHarvest(level, e.getPlayer(), e.getPos(), e.getState(), null);
    }

    @SubscribeEvent
    public void onHarvestBreakSpeed(PlayerEvent.BreakSpeed e) {
        float newSpeed;
        Player player = e.getEntity();
        Level level = player.m_20193_();
        float originalSpeed = e.getOriginalSpeed();
        if (originalSpeed != (newSpeed = TreeEvent.onHarvestBreakSpeed(level, player, originalSpeed, e.getState()))) {
            e.setNewSpeed(newSpeed);
        }
    }
}

