/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.forge.client.handler;

import dev.felnull.otyacraftengine.client.OtyacraftEngineClient;
import dev.felnull.otyacraftengine.client.callpoint.ClientCallPointManager;
import dev.felnull.otyacraftengine.client.callpoint.LayerRegister;
import dev.felnull.otyacraftengine.forge.client.handler.ClientHandlerForge;
import dev.felnull.otyacraftengine.forge.client.handler.RenderHandlerForge;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="otyacraftengine", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientBusHandler {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ClientHandlerForge.class);
        MinecraftForge.EVENT_BUS.register(RenderHandlerForge.class);
        OtyacraftEngineClient.init();
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent e) {
        ClientCallPointManager.getInstance().call().onResourceListenerRegistry(arg_0 -> ((RegisterClientReloadListenersEvent)e).registerReloadListener(arg_0));
    }

    @SubscribeEvent
    public static void onAddLayers(final EntityRenderersEvent.AddLayers e) {
        ClientCallPointManager.getInstance().call().onLayerRegistry(new LayerRegister(){

            @Override
            public <T extends LivingEntity> void addLayer(EntityType<T> entityType, Function<LivingEntityRenderer<T, ? extends EntityModel<T>>, RenderLayer<T, ? extends EntityModel<T>>> layer) {
                if (entityType == EntityType.f_20532_) {
                    for (String skin : e.getSkins()) {
                        LivingEntityRenderer renderer = e.getSkin(skin);
                        RenderLayer<T, ? extends EntityModel<T>> theLayer = layer.apply(renderer);
                        renderer.m_115326_(theLayer);
                    }
                } else {
                    LivingEntityRenderer renderer = e.getRenderer(entityType);
                    RenderLayer<T, ? extends EntityModel<T>> theLayer = layer.apply(renderer);
                    renderer.m_115326_(theLayer);
                }
            }
        });
    }
}

