/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.util.Weighted;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GearSet
extends PlaceboJsonReloadListener.TypeKeyedBase<GearSet>
implements WeightedJsonReloadListener.ILuckyWeighted {
    protected final int weight;
    protected final float quality;
    protected final List<WeightedItemStack> mainhands;
    protected final List<WeightedItemStack> offhands;
    protected final List<WeightedItemStack> boots;
    protected final List<WeightedItemStack> leggings;
    protected final List<WeightedItemStack> chestplates;
    protected final List<WeightedItemStack> helmets;
    protected final List<String> tags = new ArrayList<String>();

    public GearSet(int weight, float quality, List<WeightedItemStack> mainhands, List<WeightedItemStack> offhands, List<WeightedItemStack> boots, List<WeightedItemStack> leggings, List<WeightedItemStack> chestplates, List<WeightedItemStack> helmets) {
        this.weight = weight;
        this.quality = quality;
        this.mainhands = mainhands;
        this.offhands = offhands;
        this.boots = boots;
        this.leggings = leggings;
        this.chestplates = chestplates;
        this.helmets = helmets;
    }

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    public LivingEntity apply(LivingEntity entity) {
        entity.m_8061_(EquipmentSlot.MAINHAND, GearSet.getRandomStack(this.mainhands, entity.f_19796_));
        entity.m_8061_(EquipmentSlot.OFFHAND, GearSet.getRandomStack(this.offhands, entity.f_19796_));
        entity.m_8061_(EquipmentSlot.FEET, GearSet.getRandomStack(this.boots, entity.f_19796_));
        entity.m_8061_(EquipmentSlot.LEGS, GearSet.getRandomStack(this.leggings, entity.f_19796_));
        entity.m_8061_(EquipmentSlot.CHEST, GearSet.getRandomStack(this.chestplates, entity.f_19796_));
        entity.m_8061_(EquipmentSlot.HEAD, GearSet.getRandomStack(this.helmets, entity.f_19796_));
        return entity;
    }

    public static ItemStack getRandomStack(List<WeightedItemStack> stacks, RandomSource random) {
        if (stacks.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((WeightedItemStack)WeightedRandom.m_216822_((RandomSource)random, stacks).get()).getStack().m_41777_();
    }

    public static class WeightedItemStack
    extends Weighted {
        final ItemStack stack;

        public WeightedItemStack(ItemStack stack, int weight) {
            super(weight);
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String toString() {
            return "Stack: " + this.stack.toString() + " @ Weight: " + this.weight;
        }
    }

    public static class SetPredicateAdapter
    implements JsonDeserializer<SetPredicate>,
    JsonSerializer<SetPredicate> {
        public JsonElement serialize(SetPredicate src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.key);
        }

        public SetPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new SetPredicate(json.getAsString());
        }
    }

    public static class SetPredicate
    implements Predicate<GearSet> {
        protected final String key;
        protected final Predicate<GearSet> internal;

        public SetPredicate(String key) {
            this.key = key;
            if (key.startsWith("#")) {
                String tag = key.substring(1);
                this.internal = t -> t.tags.contains(tag);
            } else {
                ResourceLocation id = new ResourceLocation(key);
                this.internal = t -> ((GearSet)t).id.equals((Object)id);
            }
        }

        @Override
        public boolean test(GearSet t) {
            return this.internal.test(t);
        }
    }
}

