/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class CleavingAffix
extends Affix {
    protected final Map<LootRarity, CleaveValues> values;
    private static boolean cleaving = false;

    public CleavingAffix(Map<LootRarity, CleaveValues> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{ItemStack.f_41584_.format(100.0f * this.getChance(rarity, level)), this.getTargets(rarity, level)}).m_130940_(ChatFormatting.YELLOW));
    }

    private float getChance(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).chance.get(level);
    }

    private int getTargets(LootRarity rarity, float level) {
        level %= 0.5f;
        return (int)this.values.get((Object)rarity).targets.get(level *= 2.0f);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if ((double)Apotheosis.localAtkStrength >= 0.98 && !cleaving && !user.f_19853_.f_46443_) {
            cleaving = true;
            float chance = this.getChance(rarity, level);
            int targets = this.getTargets(rarity, level);
            if (user.f_19853_.f_46441_.m_188501_() < chance && user instanceof Player) {
                Player player = (Player)user;
                List nearby = target.f_19853_.m_6249_(target, new AABB(target.m_20183_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
                for (Entity e : nearby) {
                    if (targets <= 0) continue;
                    user.f_20922_ = 300;
                    player.m_5706_(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public static Predicate<Entity> cleavePredicate(Entity user, Entity target) {
        return e -> {
            if (e instanceof Animal && !(target instanceof Animal) || e instanceof AbstractVillager && !(target instanceof AbstractVillager)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof Player) {
                return false;
            }
            if (target instanceof Enemy && !(e instanceof Enemy)) {
                return false;
            }
            return e != user && e instanceof LivingEntity;
        };
    }

    public static CleavingAffix read(JsonObject obj) {
        Map values = (Map)Affix.GSON.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"values"), new TypeToken<Map<LootRarity, CleaveValues>>(){}.getType());
        return new CleavingAffix(values);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236831_(this.values, (b, key) -> b.m_130070_(key.id()), (b, pair) -> {
            pair.chance.write(buf);
            pair.targets.write(buf);
        });
    }

    public static CleavingAffix read(FriendlyByteBuf buf) {
        Map values = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> new CleaveValues(StepFunction.read((FriendlyByteBuf)b), StepFunction.read((FriendlyByteBuf)b)));
        return new CleavingAffix(values);
    }

    static class CleaveValues {
        final StepFunction chance;
        final StepFunction targets;

        CleaveValues(StepFunction chance, StepFunction targets) {
            this.chance = chance;
            this.targets = targets;
        }
    }
}

