/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.recipe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import shadows.placebo.Placebo;
import shadows.placebo.util.RunnableReloader;

public final class RecipeHelper {
    private static final Multimap<String, Consumer<RecipeFactory>> PROVIDERS = HashMultimap.create();
    protected String modid;

    public RecipeHelper(String modid) {
        this.modid = modid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProvider(Consumer<RecipeFactory> provider) {
        Multimap<String, Consumer<RecipeFactory>> multimap = PROVIDERS;
        synchronized (multimap) {
            if (provider == null) {
                Placebo.LOGGER.error("Mod {} has attempted to add a null recipe provider.", (Object)this.modid);
                Thread.dumpStack();
            }
            PROVIDERS.put((Object)this.modid, provider);
        }
    }

    public static ItemStack makeStack(Object thing) {
        if (thing instanceof ItemStack) {
            ItemStack stack = (ItemStack)thing;
            return stack;
        }
        if (thing instanceof ItemLike) {
            ItemLike il = (ItemLike)thing;
            return new ItemStack(il);
        }
        if (thing instanceof RegistryObject) {
            RegistryObject ro = (RegistryObject)thing;
            return new ItemStack((ItemLike)ro.get());
        }
        throw new IllegalArgumentException("Attempted to create an ItemStack from something that cannot be converted: " + thing);
    }

    public static NonNullList<Ingredient> createInput(String modid, boolean allowEmpty, Object ... inputArr) {
        NonNullList inputL = NonNullList.m_122779_();
        for (int i = 0; i < inputArr.length; ++i) {
            ItemStack stack;
            Object input = inputArr[i];
            if (input instanceof TagKey) {
                TagKey tag = (TagKey)input;
                inputL.add(i, (Object)Ingredient.m_204132_((TagKey)tag));
                continue;
            }
            if (input instanceof String) {
                String str = (String)input;
                inputL.add(i, (Object)Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation(str))));
                continue;
            }
            if (input instanceof ItemStack && !(stack = (ItemStack)input).m_41619_()) {
                inputL.add(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (input instanceof ItemLike || input instanceof RegistryObject) {
                inputL.add(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{RecipeHelper.makeStack(input)}));
                continue;
            }
            if (input instanceof Ingredient) {
                Ingredient ing = (Ingredient)input;
                inputL.add(i, (Object)ing);
                continue;
            }
            if (allowEmpty) {
                inputL.add(i, (Object)Ingredient.f_43901_);
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid recipe.  Complain to the author of " + modid + ". (Input " + input + " not allowed.)");
        }
        return inputL;
    }

    @ApiStatus.Internal
    public static PreparableReloadListener getReloader(RecipeManager mgr) {
        return RunnableReloader.of(() -> {
            RecipeHelper.mutableManager(mgr);
            RecipeHelper.addRecipes(mgr);
        });
    }

    private static void addRecipes(RecipeManager mgr) {
        PROVIDERS.forEach((modid, provider) -> {
            RecipeFactory factory = new RecipeFactory((String)modid);
            provider.accept(factory);
            factory.registerAll(mgr);
        });
        Placebo.LOGGER.info("Registered {} additional recipes.", (Object)RecipeFactory.totalRecipes);
        RecipeFactory.resetCaches();
    }

    private static void mutableManager(RecipeManager mgr) {
        mgr.f_199900_ = new HashMap(mgr.f_199900_);
        mgr.f_44007_ = new HashMap(mgr.f_44007_);
        for (RecipeType type : mgr.f_44007_.keySet()) {
            mgr.f_44007_.put(type, new HashMap((Map)mgr.f_44007_.get(type)));
        }
    }

    public static final class RecipeFactory {
        private final String modid;
        private final List<Recipe<?>> recipes = new ArrayList();
        private static final Multimap<String, String> MODID_TO_NAMES = HashMultimap.create();
        private static int totalRecipes = 0;

        private RecipeFactory(String modid) {
            this.modid = modid;
        }

        public void addRecipe(Recipe<?> rec) {
            if (rec == null || rec.m_6423_() == null || rec.m_7707_() == null || ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)rec.m_7707_()) == null) {
                Placebo.LOGGER.error("Attempted to add an invalid recipe {}.", rec);
                Thread.dumpStack();
            }
            this.recipes.add(rec);
        }

        public void addShapeless(Object output, Object ... inputs) {
            ItemStack out = RecipeHelper.makeStack(output);
            this.addRecipe((Recipe<?>)new ShapelessRecipe(this.name(out), this.modid, out, RecipeHelper.createInput(this.modid, false, inputs)));
        }

        public void addShaped(Object output, int width, int height, Object ... input) {
            this.addRecipe((Recipe<?>)this.genShaped(RecipeHelper.makeStack(output), width, height, input));
        }

        private ShapedRecipe genShaped(ItemStack output, int width, int height, Object ... input) {
            if (width * height != input.length) {
                throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modid);
            }
            return new ShapedRecipe(this.name(output), this.modid, width, height, RecipeHelper.createInput(this.modid, true, input), output);
        }

        private ResourceLocation name(ItemStack out) {
            Object name = ForgeRegistries.ITEMS.getKey((Object)out.m_41720_()).m_135815_();
            while (MODID_TO_NAMES.get((Object)this.modid).contains(name)) {
                name = (String)name + "_";
            }
            MODID_TO_NAMES.put((Object)this.modid, name);
            return new ResourceLocation(this.modid, (String)name);
        }

        private void registerAll(RecipeManager mgr) {
            this.recipes.forEach(r -> {
                Map map = mgr.f_44007_.computeIfAbsent(r.m_6671_(), t -> new HashMap());
                Recipe old = (Recipe)map.get(r.m_6423_());
                if (old == null) {
                    map.put(r.m_6423_(), r);
                    ++totalRecipes;
                } else {
                    Placebo.LOGGER.debug("Skipping registration for code recipe {} as a json recipe already exists with that ID.", (Object)r.m_6423_());
                }
            });
        }

        private static void resetCaches() {
            MODID_TO_NAMES.clear();
            totalRecipes = 0;
        }
    }
}

