/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import shadows.placebo.json.PlaceboJsonReloadListener;

public abstract class WeightedJsonReloadListener<V extends PlaceboJsonReloadListener.TypeKeyed<V> & ILuckyWeighted>
extends PlaceboJsonReloadListener<V> {
    protected final List<WeightedEntry.Wrapper<V>> zeroLuckList = new ArrayList<WeightedEntry.Wrapper<V>>();
    protected volatile int zeroLuckTotalWeight = 0;

    public WeightedJsonReloadListener(Logger logger, String path, boolean synced, boolean subtypes) {
        super(logger, path, synced, subtypes);
    }

    @Override
    protected void beginReload() {
        super.beginReload();
        this.zeroLuckList.clear();
        this.zeroLuckTotalWeight = 0;
    }

    @Override
    protected <T extends V> void validateItem(T item) {
        super.validateItem(item);
        Preconditions.checkArgument((((ILuckyWeighted)item).getQuality() >= 0.0f ? 1 : 0) != 0, (Object)"Item may not have negative quality!");
        Preconditions.checkArgument((((ILuckyWeighted)item).getWeight() >= 0 ? 1 : 0) != 0, (Object)"Item may not have negative weight!");
    }

    @Override
    protected <T extends V> void register(ResourceLocation key, T item) {
        super.register(key, item);
        this.zeroLuckList.add(WeightedEntry.m_146290_(item, (int)((ILuckyWeighted)item).getWeight()));
    }

    @Override
    protected void onReload() {
        super.onReload();
        this.zeroLuckTotalWeight = WeightedRandom.m_146312_(this.zeroLuckList);
        if (this.zeroLuckTotalWeight <= 0) {
            throw new RuntimeException("The total weight for the " + this.path + " manager is zero!  This is not allowed.");
        }
    }

    @Nullable
    public V getRandomItem(RandomSource rand) {
        return this.getRandomItem(rand, 0.0f);
    }

    @Nullable
    public V getRandomItem(RandomSource rand, float luck) {
        if (luck == 0.0f) {
            return (V)((PlaceboJsonReloadListener.TypeKeyed)WeightedRandom.m_216825_((RandomSource)rand, this.zeroLuckList, (int)this.zeroLuckTotalWeight).map(WeightedEntry.Wrapper::m_146310_).orElse(null));
        }
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().map(l -> ((ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((PlaceboJsonReloadListener.TypeKeyed)WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null));
    }

    @Nullable
    public V getRandomItem(RandomSource rand, float luck, Predicate<V> filter) {
        ArrayList list = new ArrayList(this.zeroLuckList.size());
        this.registry.values().stream().filter(filter).map(l -> ((ILuckyWeighted)((Object)l)).wrap(luck)).forEach(list::add);
        return (V)((PlaceboJsonReloadListener.TypeKeyed)WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null));
    }

    public static interface ILuckyWeighted {
        public float getQuality();

        public int getWeight();

        default public <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(float luck) {
            return ILuckyWeighted.wrap(this, luck);
        }

        public static <T extends ILuckyWeighted> WeightedEntry.Wrapper<T> wrap(T item, float luck) {
            return WeightedEntry.m_146290_(item, (int)(item.getWeight() + (int)(luck * item.getQuality())));
        }
    }

    public static interface IStaged {
        @Nullable
        public Set<String> getStages();

        public static <T extends IStaged> Predicate<T> matches(String stage) {
            return obj -> {
                Set<String> stages = obj.getStages();
                return stages == null || stages.contains(stage);
            };
        }

        public static <T extends IStaged> Predicate<T> matchesAny(Collection<String> stages) {
            return obj -> {
                Set<String> ourStages = obj.getStages();
                if (ourStages == null) return true;
                if (!stages.stream().anyMatch(ourStages::contains)) return false;
                return true;
            };
        }
    }

    public static interface IDimensional {
        @Nullable
        public Set<ResourceLocation> getDimensions();

        public static <T extends IDimensional> Predicate<T> matches(ResourceLocation dimId) {
            return obj -> {
                Set<ResourceLocation> dims = obj.getDimensions();
                return dims == null || dims.isEmpty() || dims.contains(dimId);
            };
        }

        public static <T extends IDimensional> Predicate<T> matches(Level level) {
            return IDimensional.matches(level.m_46472_().m_135782_());
        }
    }
}

