/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ModCraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static FluidStack fluidStackFromJson(JsonObject json) {
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        if (fluidName.equals("minecraft:empty")) {
            return FluidStack.EMPTY;
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(fluidName));
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("unknown fluid: " + fluidName);
        }
        int amount = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)1000);
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (json.has("nbt")) {
            JsonElement element = json.get("nbt");
            try {
                if (element.isJsonObject()) {
                    fluidStack.setTag(TagParser.m_129359_((String)GSON.toJson(element)));
                } else {
                    fluidStack.setTag(TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt")));
                }
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException((Throwable)e);
            }
        }
        return fluidStack;
    }

    public static JsonObject fluidStackToJson(FluidStack f) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", PneumaticCraftUtils.getRegistryName(f.getFluid()).orElseThrow().toString());
        json.addProperty("amount", (Number)f.getAmount());
        if (f.hasTag()) {
            json.addProperty("nbt", f.getTag().toString());
        }
        return json;
    }
}

