/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTooBigException;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeCylinder;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeGrid;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeLine;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypePyramid;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeRandom;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeSphere;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeWall;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    private DroneAIManager aiManager;
    private final BlockPos[] pos = new BlockPos[]{null, null};
    private final String[] varNames = new String[]{"", ""};
    public AreaType type = new AreaTypeBox();
    private IVariableProvider variableProvider;
    private UUID playerID;
    private static final Map<String, Integer> areaTypeToID = new HashMap<String, Integer>();
    private static final List<Supplier<? extends AreaType>> areaTypeFactories = new ArrayList<Supplier<? extends AreaType>>();

    public ProgWidgetArea() {
        super((ProgWidgetType)ModProgWidgets.AREA.get());
    }

    private static <T extends AreaType> void register(String id, Supplier<T> factory) {
        if (areaTypeToID.containsKey(id)) {
            throw new IllegalStateException("Area type " + id + " could not be registered, duplicate id");
        }
        areaTypeFactories.add(factory);
        areaTypeToID.put(id, areaTypeFactories.size() - 1);
    }

    public static List<AreaType> getAllAreaTypes() {
        return areaTypeFactories.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ProgWidgetArea fromPosition(BlockPos p1) {
        return ProgWidgetArea.fromPositions(p1, p1);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expand) {
        return ProgWidgetArea.fromPosition(p1, expand, expand, expand);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expandX, int expandY, int expandZ) {
        int x = expandX / 2;
        int y = expandY / 2;
        int z = expandZ / 2;
        return ProgWidgetArea.fromPositions(p1.m_7918_(-x, -y, -z), p1.m_7918_(x, y, z));
    }

    public static ProgWidgetArea fromPositions(BlockPos p1, BlockPos p2) {
        ProgWidgetArea area = new ProgWidgetArea();
        area.setPos(0, p1);
        area.setPos(1, p2);
        return area;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        ArrayList<Component> res = new ArrayList<Component>();
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            res.add((Component)Component.m_237113_((String)PneumaticCraftUtils.posToString(this.pos[0])));
        } else {
            if (!this.varNames[0].isEmpty()) {
                res.add((Component)Component.m_237113_((String)("\"" + this.varNames[0] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[0])) {
                res.add((Component)Component.m_237113_((String)PneumaticCraftUtils.posToString(this.pos[0])));
            }
            if (!this.varNames[1].isEmpty() && !this.varNames[1].equals(this.varNames[0])) {
                res.add((Component)Component.m_237113_((String)("\"" + this.varNames[1] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[1]) && !this.pos[1].equals((Object)this.pos[0])) {
                res.add((Component)Component.m_237113_((String)PneumaticCraftUtils.posToString(this.pos[1])));
            }
            if (res.size() == 2) {
                MutableComponent c = PneumaticCraftUtils.xlate(this.type.getTranslationKey(), new Object[0]).m_130946_("/");
                ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
                this.type.addUIWidgets(widgets);
                c.m_130946_(String.join((CharSequence)"/", widgets.stream().map(AreaType.AreaTypeWidget::getCurValue).toList()));
                res.add((Component)c);
            }
        }
        return res;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.varNames[0].isEmpty() && this.varNames[0].equals(this.varNames[1])) {
            curTooltip.add((Component)Component.m_237113_((String)String.format("Var \"%s\"", this.varNames[0])).m_130940_(ChatFormatting.YELLOW));
        } else if (PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            curTooltip.add((Component)Component.m_237113_((String)"P1: ").m_7220_((Component)Component.m_237113_((String)PneumaticCraftUtils.posToString(this.pos[0])).m_130940_(ChatFormatting.YELLOW)));
        } else {
            int n = curTooltip.size();
            for (int i = 0; i < 2; ++i) {
                String text;
                String string = this.varNames[i].isEmpty() ? (this.pos[i] == null ? null : PneumaticCraftUtils.posToString(this.pos[i])) : (text = String.format("Var \"%s\"", this.varNames[i]));
                if (text == null) continue;
                curTooltip.add((Component)Component.m_237113_((String)("P" + (i + 1) + ": ")).m_7220_((Component)Component.m_237113_((String)text).m_130940_(ChatFormatting.YELLOW)));
            }
            if (curTooltip.size() - n == 2) {
                this.addAreaTypeTooltip(curTooltip);
            }
        }
    }

    public void addAreaTypeTooltip(List<Component> curTooltip) {
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]).m_7220_((Component)PneumaticCraftUtils.xlate(this.type.getTranslationKey(), new Object[0]).m_130940_(ChatFormatting.YELLOW)));
        ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
        this.type.addUIWidgets(widgets);
        for (AreaType.AreaTypeWidget widget : widgets) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate(widget.title, new Object[0]).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)widget.getCurValue()).m_130940_(ChatFormatting.YELLOW)));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && this.pos[0] == null && this.pos[1] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if (!(this.type instanceof AreaTypeBox)) {
            IProgWidget p = this;
            while ((p = p.getParent()) != null) {
                ProgWidgetType<?> type = p.getType();
                if (type != ModProgWidgets.ENTITY_ATTACK.get() && type != ModProgWidgets.ENTITY_IMPORT.get() && type != ModProgWidgets.ENTITY_RIGHT_CLICK.get() && type != ModProgWidgets.CONDITION_ENTITY.get() && type != ModProgWidgets.PICKUP_ITEM.get()) continue;
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.onlyAreaTypeBox", PneumaticCraftUtils.xlate(p.getTranslationKey(), new Object[0])));
                break;
            }
        }
    }

    private BlockPos[] getAreaPoints() {
        BlockPos[] points = new BlockPos[2];
        for (int i = 0; i < 2; ++i) {
            points[i] = this.varNames[i].isEmpty() ? this.pos[i] : (this.variableProvider != null ? (BlockPos)this.variableProvider.getCoordinate(this.playerID, this.varNames[i]).orElse(null) : null);
        }
        if (points[0] == null && points[1] == null) {
            return new BlockPos[]{null, null};
        }
        if (points[0] == null) {
            return new BlockPos[]{points[1], null};
        }
        if (points[1] == null) {
            return new BlockPos[]{points[0], null};
        }
        return points;
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return (ProgWidgetType)ModProgWidgets.AREA.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of((Object)((ProgWidgetType)ModProgWidgets.AREA.get()));
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        this.getArea(area, this.type);
    }

    public void getArea(Set<BlockPos> area, AreaType areaType) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].m_123341_(), areaPoints[1].m_123341_());
            minY = Math.min(areaPoints[0].m_123342_(), areaPoints[1].m_123342_());
            minZ = Math.min(areaPoints[0].m_123343_(), areaPoints[1].m_123343_());
            maxX = Math.max(areaPoints[0].m_123341_(), areaPoints[1].m_123341_());
            maxY = Math.max(areaPoints[0].m_123342_(), areaPoints[1].m_123342_());
            maxZ = Math.max(areaPoints[0].m_123343_(), areaPoints[1].m_123343_());
        } else {
            minX = maxX = areaPoints[0].m_123341_();
            minY = maxY = areaPoints[0].m_123342_();
            minZ = maxZ = areaPoints[0].m_123343_();
        }
        BlockPos p1 = areaPoints[0];
        BlockPos p2 = areaPoints[1] != null ? areaPoints[1] : p1;
        int size = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int maxSize = (Integer)ConfigHelper.common().general.maxProgrammingArea.get();
        if (size > maxSize && this.aiManager != null) {
            IDroneBase drone = this.aiManager.getDrone();
            Log.warning(String.format("Drone @ %s (DIM %s) was killed due to excessively large area (%d > %d). See 'maxProgrammingArea' in config.", drone.getDronePos().toString(), drone.world().m_46472_().m_135782_(), size, maxSize), new Object[0]);
            drone.overload("areaTooLarge", maxSize);
            return;
        }
        Consumer<BlockPos> addFunc = p -> {
            if (area.add((BlockPos)p) && area.size() > maxSize) {
                throw new AreaTooBigException();
            }
        };
        try {
            areaType.addArea(addFunc, p1, p2, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (AreaTooBigException areaTooBigException) {
            // empty catch block
        }
    }

    private AABB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].m_123341_(), areaPoints[1].m_123341_());
            minY = Math.min(areaPoints[0].m_123342_(), areaPoints[1].m_123342_());
            minZ = Math.min(areaPoints[0].m_123343_(), areaPoints[1].m_123343_());
            maxX = Math.max(areaPoints[0].m_123341_(), areaPoints[1].m_123341_());
            maxY = Math.max(areaPoints[0].m_123342_(), areaPoints[1].m_123342_());
            maxZ = Math.max(areaPoints[0].m_123343_(), areaPoints[1].m_123343_());
        } else {
            minX = maxX = areaPoints[0].m_123341_();
            minY = maxY = areaPoints[0].m_123342_();
            minZ = maxZ = areaPoints[0].m_123343_();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    List<Entity> getEntitiesWithinArea(Level world, Predicate<? super Entity> predicate) {
        AABB aabb = this.getAABB();
        return aabb != null ? world.m_6249_((Entity)null, aabb, predicate) : new ArrayList<Entity>();
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        BlockPos pos1 = this.getPos(0).orElse(BlockPos.f_121853_);
        BlockPos pos2 = this.getPos(1).orElse(BlockPos.f_121853_);
        buf.m_130064_(pos1);
        BlockPos offset = pos1.m_121996_((Vec3i)pos2).m_7918_(127, 127, 127);
        buf.m_130064_(offset);
        buf.m_130130_(areaTypeToID.get(this.type.getName()).intValue());
        this.type.writeToPacket(buf);
        buf.m_130070_(this.varNames[0]);
        buf.m_130070_(this.varNames[1]);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.pos[0] = buf.m_130135_();
        BlockPos offset = buf.m_130135_().m_7918_(-127, -127, -127);
        this.pos[1] = this.pos[0].m_121996_((Vec3i)offset);
        this.type = ProgWidgetArea.createType(buf.m_130242_());
        this.type.readFromPacket(buf);
        this.varNames[0] = buf.m_130136_(64);
        this.varNames[1] = buf.m_130136_(64);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.getPos(0).ifPresent(pos -> tag.m_128365_("pos1", (Tag)NbtUtils.m_129224_((BlockPos)pos)));
        this.getPos(1).ifPresent(pos -> tag.m_128365_("pos2", (Tag)NbtUtils.m_129224_((BlockPos)pos)));
        tag.m_128359_("type", this.type.getName());
        this.type.writeToNBT(tag);
        if (!this.varNames[0].isEmpty()) {
            tag.m_128359_("var1", this.varNames[0]);
        } else {
            tag.m_128473_("var1");
        }
        if (!this.varNames[1].isEmpty()) {
            tag.m_128359_("var2", this.varNames[1]);
        } else {
            tag.m_128473_("var2");
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        if (tag.m_128441_("x1")) {
            this.pos[0] = new BlockPos(tag.m_128451_("x1"), tag.m_128451_("y1"), tag.m_128451_("z1"));
            this.pos[1] = new BlockPos(tag.m_128451_("x2"), tag.m_128451_("y2"), tag.m_128451_("z2"));
            this.varNames[0] = tag.m_128461_("coord1Variable");
            this.varNames[1] = tag.m_128461_("coord2Variable");
        } else {
            this.pos[0] = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos1"));
            this.pos[1] = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos2"));
            this.varNames[0] = tag.m_128461_("var1");
            this.varNames[1] = tag.m_128461_("var2");
        }
        this.type = ProgWidgetArea.createType(tag.m_128461_("type"));
        this.type.readFromNBT(tag);
    }

    public static AreaType createType(String id) {
        if (!areaTypeToID.containsKey(id)) {
            Log.error("No Area type found for id '" + id + "'! Substituting Box!", new Object[0]);
            return new AreaTypeBox();
        }
        return ProgWidgetArea.createType(areaTypeToID.get(id));
    }

    public static AreaType createType(int id) {
        return areaTypeFactories.get(id).get();
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    public void setPos(int index, BlockPos newPos) {
        this.pos[index] = newPos;
    }

    public Optional<BlockPos> getPos(int index) {
        return Optional.ofNullable(this.pos[index]);
    }

    public String getVarName(int index) {
        return this.varNames[index];
    }

    public void setVarName(int index, String varName) {
        this.varNames[index] = varName;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
        this.variableProvider = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.varNames[0]);
        variables.add(this.varNames[1]);
    }

    public void setVariableProvider(IVariableProvider provider, UUID playerID) {
        this.variableProvider = provider;
        this.playerID = playerID;
    }

    static {
        ProgWidgetArea.register("box", AreaTypeBox::new);
        ProgWidgetArea.register("sphere", AreaTypeSphere::new);
        ProgWidgetArea.register("line", AreaTypeLine::new);
        ProgWidgetArea.register("wall", AreaTypeWall::new);
        ProgWidgetArea.register("cylinder", AreaTypeCylinder::new);
        ProgWidgetArea.register("pyramid", AreaTypePyramid::new);
        ProgWidgetArea.register("grid", AreaTypeGrid::new);
        ProgWidgetArea.register("random", AreaTypeRandom::new);
    }
}

