/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import me.desht.pneumaticcraft.api.misc.DamageSources;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public class PNCDamageSource
extends DamageSource {
    public static final DamageSource PRESSURE = new PNCDamageSource("pressure", 2).m_19380_();
    public static final DamageSource ETCHING_ACID = new PNCDamageSource("acid", 2);
    public static final DamageSource SECURITY_STATION = new PNCDamageSource("securityStation").m_19380_();
    public static final DamageSource PLASTIC_BLOCK = new PNCDamageSource("plastic_block", 2);
    private final int deathMessageCount;

    private PNCDamageSource(String damageType, int messages) {
        super(damageType);
        this.deathMessageCount = messages;
    }

    private PNCDamageSource(String damageType) {
        this(damageType, 1);
    }

    public Component m_6157_(LivingEntity dyingEntity) {
        int messageNumber = dyingEntity.m_217043_().m_188503_(this.deathMessageCount) + 1;
        LivingEntity killer = dyingEntity.m_21232_();
        String s = "pneumaticcraft.death.attack." + this.f_19326_ + messageNumber;
        String s1 = s + ".player";
        return killer != null && I18n.m_118936_((String)s1) ? Component.m_237110_((String)s1, (Object[])new Object[]{dyingEntity.m_5446_(), killer.m_5446_()}) : Component.m_237110_((String)s, (Object[])new Object[]{dyingEntity.m_5446_()});
    }

    public static enum DamageSourcesImpl implements DamageSources
    {
        INSTANCE;


        @Override
        public boolean isPressureDamage(DamageSource damageSource) {
            return damageSource == PRESSURE;
        }

        @Override
        public boolean isSecurityStationDamage(DamageSource damageSource) {
            return damageSource == SECURITY_STATION;
        }

        @Override
        public boolean isEtchingAcidDamage(DamageSource damageSource) {
            return damageSource == ETCHING_ACID;
        }

        @Override
        public boolean isPlasticBlockDamage(DamageSource damageSource) {
            return damageSource == PLASTIC_BLOCK;
        }

        @Override
        public boolean isDroneOverloadDamage(DamageSource damageSource) {
            return damageSource instanceof DamageSourceDroneOverload;
        }
    }

    public static class DamageSourceDroneOverload
    extends PNCDamageSource {
        private final String msgKey;
        private final Object[] params;

        public DamageSourceDroneOverload(String msgKey, Object ... params) {
            super("droneOverload");
            this.m_19380_();
            this.m_19381_();
            this.msgKey = msgKey;
            this.params = new Object[params.length];
            System.arraycopy(params, 0, this.params, 0, params.length);
        }

        @Override
        public Component m_6157_(LivingEntity dyingEntity) {
            return Component.m_237110_((String)("pneumaticcraft.death.drone.overload." + this.msgKey), (Object[])this.params);
        }
    }
}

