/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;

public class ProgressBarRenderer {
    public static void render3d(PoseStack matrixStack, MultiBufferSource buffer, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.m_14179_((float)(progress / 100.0f), (float)minX, (float)maxX);
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.UNTEXTURED_QUAD_NO_DEPTH, (posMat, builder) -> {
            builder.m_85982_(posMat, minX, minY, zLevel).m_85950_(f1[0], f1[1], f1[2], f1[3]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, minX, minY + (maxY - minY), zLevel).m_85950_(f1[0], f1[1], f1[2], f1[3]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, x, minY + (maxY - minY), zLevel).m_85950_(f2[0], f2[1], f2[2], f2[3]).m_85969_(0xF000F0).m_5752_();
            builder.m_85982_(posMat, x, minY, zLevel).m_85950_(f2[0], f2[1], f2[2], f2[3]).m_85969_(0xF000F0).m_5752_();
        });
        Matrix3f normal = matrixStack.m_85850_().m_85864_();
        RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getLineLoops(1.5), (posMat, builder) -> {
            RenderUtils.normalLine(builder, posMat, normal, minX, minY, zLevel, minX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, minX, maxY, zLevel, maxX, maxY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, maxX, maxY, zLevel, maxX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
            RenderUtils.normalLine(builder, posMat, normal, maxX, minY, zLevel, minX, minY, zLevel, 255.0f, 0.0f, 0.0f, 0.0f, true);
        });
    }

    public static void render2d(PoseStack matrixStack, float minX, float minY, float maxX, float maxY, float zLevel, float progress, int color1, int color2) {
        Pair<float[], float[]> cols = ProgressBarRenderer.calcColors(color1, color2, progress);
        float[] f1 = (float[])cols.getLeft();
        float[] f2 = (float[])cols.getRight();
        float x = Mth.m_14179_((float)(progress / 100.0f), (float)minX, (float)maxX);
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        builder.m_85982_(posMat, minX, minY, zLevel).m_85950_(f1[0], f1[1], f1[2], f1[3]).m_5752_();
        builder.m_85982_(posMat, minX, minY + (maxY - minY), zLevel).m_85950_(f1[0], f1[1], f1[2], f1[3]).m_5752_();
        builder.m_85982_(posMat, x, minY + (maxY - minY), zLevel).m_85950_(f2[0], f2[1], f2[2], f2[3]).m_5752_();
        builder.m_85982_(posMat, x, minY, zLevel).m_85950_(f2[0], f2[1], f2[2], f2[3]).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69832_((float)2.0f);
        builder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        builder.m_85982_(posMat, minX, minY, zLevel).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, minX, maxY, zLevel).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, maxX, maxY, zLevel).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(posMat, maxX, minY, zLevel).m_85950_(0.0f, 0.0f, 0.0f, 1.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    private static Pair<float[], float[]> calcColors(int color1, int color2, float progress) {
        float[] f1 = new TintColor(color1, true).getComponents(null);
        if (color1 != color2) {
            float[] f2 = new TintColor(color2, true).getComponents(null);
            for (int i = 0; i < f1.length; ++i) {
                f2[i] = Mth.m_14179_((float)(progress / 100.0f), (float)f1[i], (float)f2[i]);
            }
            return Pair.of((Object)f1, (Object)f2);
        }
        return Pair.of((Object)f1, (Object)f1);
    }
}

