/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.client.render.ProgWidgetRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;

public class ProgrammerWidgetAreaRenderer {
    private static final float SCALE_PER_STEP = 0.2f;
    private final Screen parent;
    private final List<IProgWidget> progWidgets;
    private final int guiLeft;
    private final int guiTop;
    private final int startX;
    private final int startY;
    private final int areaWidth;
    private final int areaHeight;
    private final WidgetVerticalScrollbar scaleScroll;
    private double translatedX;
    private double translatedY;
    private int lastZoom;
    private final List<List<Component>> widgetErrors = new ArrayList<List<Component>>();
    private final List<List<Component>> widgetWarnings = new ArrayList<List<Component>>();
    private int totalErrors = 0;
    private int totalWarnings = 0;
    private static final float ARROW_ANGLE = (float)Math.toRadians(30.0);
    private static final float ARROW_SIZE = 5.0f;

    public ProgrammerWidgetAreaRenderer(Screen parent, List<IProgWidget> progWidgets, int guiLeft, int guiTop, Rect2i bounds, double translatedX, double translatedY, int lastZoom) {
        this.parent = parent;
        this.progWidgets = progWidgets;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.startX = bounds.m_110085_();
        this.startY = bounds.m_110086_();
        this.areaWidth = bounds.m_110090_();
        this.areaHeight = bounds.m_110091_();
        this.translatedX = translatedX;
        this.translatedY = translatedY;
        this.lastZoom = lastZoom;
        this.scaleScroll = new WidgetVerticalScrollbar(guiLeft + this.areaWidth + 8, guiTop + 40, this.areaHeight - 25).setStates(9).setCurrentState(lastZoom).setListening(true);
    }

    public WidgetVerticalScrollbar getScrollBar() {
        return this.scaleScroll;
    }

    int getLastZoom() {
        return this.lastZoom;
    }

    double getTranslatedX() {
        return this.translatedX;
    }

    double getTranslatedY() {
        return this.translatedY;
    }

    private void addMessages(List<Component> tooltip, List<Component> msgList, String key, ChatFormatting color) {
        if (!msgList.isEmpty()) {
            tooltip.add((Component)PneumaticCraftUtils.xlate(key, new Object[0]).m_130944_(new ChatFormatting[]{color, ChatFormatting.UNDERLINE}));
            for (Component msg : msgList) {
                tooltip.add((Component)Component.m_237113_((String)"\u25b6 ").m_7220_(msg).m_130940_(color));
            }
        }
    }

    public void renderForeground(PoseStack matrixStack, int x, int y, IProgWidget tooltipExcludingWidget, Font font) {
        IProgWidget progWidget;
        int idx = this.getHoveredWidgetIndex(x, y);
        if (idx >= 0 && (progWidget = this.progWidgets.get(idx)) != null && progWidget != tooltipExcludingWidget) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            progWidget.getTooltip(tooltip);
            if (this.widgetErrors.size() == this.progWidgets.size()) {
                this.addMessages(tooltip, this.widgetErrors.get(idx), "pneumaticcraft.gui.programmer.errors", ChatFormatting.RED);
            }
            if (this.widgetWarnings.size() == this.progWidgets.size()) {
                this.addMessages(tooltip, this.widgetWarnings.get(idx), "pneumaticcraft.gui.programmer.warnings", ChatFormatting.YELLOW);
            }
            this.addAdditionalInfoToTooltip(progWidget, tooltip);
            if (!tooltip.isEmpty()) {
                this.parent.m_96617_(matrixStack, GuiUtils.wrapTextComponentList(tooltip, this.areaWidth * 2 / 3, font), x - this.guiLeft, y - this.guiTop);
            }
        }
    }

    private int getHoveredWidgetIndex(int mouseX, int mouseY) {
        float scale = this.getScale();
        for (int i = this.progWidgets.size() - 1; i >= 0; --i) {
            IProgWidget widget = this.progWidgets.get(i);
            if (this.isOutsideProgrammingArea(widget) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft >= (double)widget.getX()) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop >= (double)widget.getY()) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft <= (double)((float)widget.getX() + (float)widget.getWidth() / 2.0f)) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop <= (double)((float)widget.getY() + (float)widget.getHeight() / 2.0f))) continue;
            return i;
        }
        return -1;
    }

    public IProgWidget getHoveredWidget(int mouseX, int mouseY) {
        int i = this.getHoveredWidgetIndex(mouseX, mouseY);
        return i >= 0 ? this.progWidgets.get(i) : null;
    }

    protected void addAdditionalInfoToTooltip(IProgWidget widget, List<Component> tooltip) {
        if (ProgWidgetGuiManager.hasGui(widget)) {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.rightClickForOptions", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        ThirdPartyManager.instance().getDocsProvider().addTooltip(tooltip, false);
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            PneumaticCraftUtils.getRegistryName(ModProgWidgets.PROG_WIDGETS.get(), widget.getType()).ifPresent(regName -> tooltip.add((Component)Component.m_237113_((String)regName.toString()).m_130940_(ChatFormatting.DARK_GRAY)));
        }
    }

    public void tick() {
        if ((ClientUtils.getClientLevel().m_46467_() & 0xFL) == 0L || this.widgetErrors.size() != this.progWidgets.size() || this.widgetWarnings.size() != this.progWidgets.size()) {
            this.widgetErrors.clear();
            this.widgetWarnings.clear();
            this.totalWarnings = 0;
            this.totalErrors = 0;
            for (IProgWidget widget : this.progWidgets) {
                ArrayList<Component> e = new ArrayList<Component>();
                widget.addErrors(e, this.progWidgets);
                this.widgetErrors.add(e.isEmpty() ? Collections.emptyList() : e);
                this.totalErrors += e.size();
                ArrayList<Component> w = new ArrayList<Component>();
                widget.addWarnings(w, this.progWidgets);
                this.widgetWarnings.add(w.isEmpty() ? Collections.emptyList() : w);
                this.totalWarnings += w.size();
            }
        }
    }

    public void render(PoseStack matrixStack, int x, int y, boolean showFlow, boolean showInfo) {
        if (this.scaleScroll.getState() != this.lastZoom) {
            float shift = 0.2f * (float)(this.scaleScroll.getState() - this.lastZoom);
            float prevScale = 2.0f - (float)this.lastZoom * 0.2f;
            this.translatedX += (double)shift * ((double)x - this.translatedX) / (double)prevScale;
            this.translatedY += (double)shift * ((double)y - this.translatedY) / (double)prevScale;
        }
        this.lastZoom = this.scaleScroll.getState();
        Window mw = Minecraft.m_91087_().m_91268_();
        double sf = mw.m_85449_();
        GL11.glScissor((int)((int)((double)(this.guiLeft + this.startX) * mw.m_85449_())), (int)((int)((double)mw.m_85446_() * sf - (double)this.areaHeight * sf - (double)(this.guiTop + this.startY) * sf)), (int)((int)((double)this.areaWidth * sf)), (int)((int)((double)this.areaHeight * sf)));
        GL11.glEnable((int)3089);
        matrixStack.m_85836_();
        matrixStack.m_85837_(this.translatedX, this.translatedY, 0.0);
        float scale = this.getScale();
        matrixStack.m_85841_(scale, scale, 1.0f);
        if (showFlow) {
            this.showFlow(matrixStack);
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (IProgWidget widget : this.progWidgets) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget);
            matrixStack.m_85849_();
        }
        if (this.widgetErrors.size() == this.progWidgets.size() && this.widgetWarnings.size() == this.progWidgets.size()) {
            for (int i = 0; i < this.progWidgets.size(); ++i) {
                if (!this.widgetErrors.get(i).isEmpty()) {
                    this.drawBorder(matrixStack, this.progWidgets.get(i), -65536);
                    continue;
                }
                if (this.widgetWarnings.get(i).isEmpty()) continue;
                this.drawBorder(matrixStack, this.progWidgets.get(i), -256);
            }
        }
        this.renderAdditionally(matrixStack);
        RenderSystem.m_69461_();
        if (showInfo) {
            for (IProgWidget widget : this.progWidgets) {
                PoseStack posestack = RenderSystem.m_157191_();
                posestack.m_85836_();
                posestack.m_85837_(this.translatedX, this.translatedY, 0.0);
                posestack.m_85841_(this.getScale(), this.getScale(), 1.0f);
                posestack.m_85837_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
                posestack.m_85841_(0.5f, 0.5f, 1.0f);
                RenderSystem.m_157182_();
                ProgWidgetRenderer.doItemRendering2d(widget);
                posestack.m_85849_();
                RenderSystem.m_157182_();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
                matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
                ProgWidgetRenderer.doExtraRendering2d(matrixStack, widget);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        GL11.glDisable((int)3089);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (mouseButton == 0 && !this.scaleScroll.isDragging() && new Rect2i(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).m_110087_((int)mouseX, (int)mouseY)) {
            this.translatedX += dx;
            this.translatedY += dy;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dir) {
        return this.scaleScroll.m_6050_(mouseX, mouseY, dir);
    }

    protected void renderAdditionally(PoseStack matrixStack) {
    }

    protected void drawBorder(PoseStack matrixStack, IProgWidget widget, int color) {
        this.drawBorder(matrixStack, widget, color, 0);
    }

    protected void drawBorder(PoseStack matrixStack, IProgWidget widget, int color, int inset) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), 0.0);
        matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
        this.vLine(matrixStack, inset, inset, widget.getHeight() - inset, color);
        this.vLine(matrixStack, widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        this.hLine(matrixStack, widget.getWidth() - inset, inset, inset, color);
        this.hLine(matrixStack, widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        matrixStack.m_85849_();
    }

    private void hLine(PoseStack matrixStack, int minX, int maxX, int y, int color) {
        if (maxX < minX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)minX, (int)y, (int)(maxX + 1), (int)(y + 1), (int)color);
    }

    private void vLine(PoseStack matrixStack, int x, int minY, int maxY, int color) {
        if (maxY < minY) {
            int i = minY;
            minY = maxY;
            maxY = i;
        }
        GuiComponent.m_93172_((PoseStack)matrixStack, (int)x, (int)(minY + 1), (int)(x + 1), (int)maxY, (int)color);
    }

    private void showFlow(PoseStack matrixStack) {
        RenderSystem.m_69832_((float)1.0f);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        BufferBuilder wr = Tesselator.m_85913_().m_85915_();
        wr.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85814_);
        HashMap labelWidgets = new HashMap();
        for (IProgWidget w : this.progWidgets) {
            if (!(w instanceof ILabel)) continue;
            ILabel l = (ILabel)((Object)w);
            labelWidgets.computeIfAbsent(l.getLabel(), k -> new ArrayList()).add(w);
        }
        Matrix4f posMat = matrixStack.m_85850_().m_85861_();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IJump)) continue;
            IJump jump = (IJump)((Object)widget);
            for (String jumpLocation : jump.getPossibleJumpLocations()) {
                for (IProgWidget labelWidget : labelWidgets.getOrDefault(jumpLocation, Collections.emptyList())) {
                    int x1 = widget.getX() + widget.getWidth() / 4;
                    int y1 = widget.getY() + widget.getHeight() / 4;
                    int x2 = labelWidget.getX() + labelWidget.getWidth() / 4;
                    int y2 = labelWidget.getY() + labelWidget.getHeight() / 4;
                    float midX = (float)(x2 + x1) / 2.0f;
                    float midY = (float)(y2 + y1) / 2.0f;
                    wr.m_85982_(posMat, (float)(this.guiLeft + x1), (float)(this.guiTop + y1), 0.0f).m_5752_();
                    wr.m_85982_(posMat, (float)(this.guiLeft + x2), (float)(this.guiTop + y2), 0.0f).m_5752_();
                    Vec3 arrowVec = new Vec3((double)(x1 - x2), (double)(y1 - y2), 0.0).m_82541_();
                    arrowVec = new Vec3(arrowVec.f_82479_ * 5.0, 0.0, arrowVec.f_82480_ * 5.0);
                    arrowVec = arrowVec.m_82524_(ARROW_ANGLE);
                    wr.m_85982_(posMat, (float)this.guiLeft + midX, (float)this.guiTop + midY, 0.0f).m_5752_();
                    wr.m_85982_(posMat, (float)this.guiLeft + midX + (float)arrowVec.f_82479_, (float)this.guiTop + midY + (float)arrowVec.f_82481_, 0.0f).m_5752_();
                    arrowVec = arrowVec.m_82524_(-2.0f * ARROW_ANGLE);
                    wr.m_85982_(posMat, (float)this.guiLeft + midX, (float)this.guiTop + midY, 0.0f).m_5752_();
                    wr.m_85982_(posMat, (float)this.guiLeft + midX + (float)arrowVec.f_82479_, (float)this.guiTop + midY + (float)arrowVec.f_82481_, 0.0f).m_5752_();
                }
            }
        }
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69493_();
    }

    public float getScale() {
        return 2.0f - (float)this.scaleScroll.getState() * 0.2f;
    }

    boolean isOutsideProgrammingArea(IProgWidget widget) {
        float scale = this.getScale();
        int x = (int)((float)(widget.getX() + this.guiLeft) * scale);
        int y = (int)((float)(widget.getY() + this.guiTop) * scale);
        x = (int)((double)x + (this.translatedX - (double)this.guiLeft));
        y = (int)((double)y + (this.translatedY - (double)this.guiTop));
        return x < this.startX || (float)x + (float)widget.getWidth() * scale / 2.0f > (float)(this.startX + this.areaWidth) || y < this.startY || (float)y + (float)widget.getHeight() * scale / 2.0f > (float)(this.startY + this.areaHeight);
    }

    public void gotoPiece(IProgWidget widget) {
        if (widget != null) {
            this.scaleScroll.currentScroll = 0.0f;
            this.lastZoom = 0;
            this.translatedX = (double)(-widget.getX()) * 2.0 + (double)this.areaWidth / 2.0 - (double)this.guiLeft;
            this.translatedY = (double)(-widget.getY()) * 2.0 + (double)this.areaHeight / 2.0 - (double)this.guiTop;
        }
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalWarnings() {
        return this.totalWarnings;
    }
}

