/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.CrushingIRecipe;
import mekanism.common.recipe.impl.EnrichingIRecipe;
import mekanism.common.recipe.impl.SmeltingIRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack")
public abstract class ItemStackToItemStackRecipeManager
extends MekanismRecipeManager<ItemStackToItemStackRecipe> {
    protected ItemStackToItemStackRecipeManager(IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ItemStackIngredient input, IItemStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, output));
    }

    public final ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, IItemStack output) {
        return this.makeRecipe(id, input, this.getAndValidateNotEmpty(output));
    }

    protected abstract ItemStackToItemStackRecipe makeRecipe(ResourceLocation var1, ItemStackIngredient var2, ItemStack var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(ItemStackToItemStackRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((ItemStackToItemStackRecipe)this.recipe).getOutputDefinition(), ItemStackUtil::getCommandString);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Smelting")
    public static class EnergizedSmelterRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnergizedSmelterRecipeManager INSTANCE = new EnergizedSmelterRecipeManager();

        private EnergizedSmelterRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.SMELTING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new SmeltingIRecipe(id, input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Enriching")
    public static class EnrichmentChamberRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final EnrichmentChamberRecipeManager INSTANCE = new EnrichmentChamberRecipeManager();

        private EnrichmentChamberRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.ENRICHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new EnrichingIRecipe(id, input, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ItemStackToItemStack.Crushing")
    public static class CrusherRecipeManager
    extends ItemStackToItemStackRecipeManager {
        public static final CrusherRecipeManager INSTANCE = new CrusherRecipeManager();

        private CrusherRecipeManager() {
            super((IMekanismRecipeTypeProvider<ItemStackToItemStackRecipe, ?>)MekanismRecipeType.CRUSHING);
        }

        @Override
        protected ItemStackToItemStackRecipe makeRecipe(ResourceLocation id, ItemStackIngredient input, ItemStack output) {
            return new CrushingIRecipe(id, input, output);
        }
    }
}

