/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.Objects;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class SorterFilter<FILTER extends SorterFilter<FILTER>>
extends BaseFilter<FILTER> {
    public static final int MAX_LENGTH = 48;
    public EnumColor color;
    public boolean allowDefault;
    public boolean sizeMode;
    public int min;
    public int max;

    protected SorterFilter() {
    }

    protected SorterFilter(FILTER filter) {
        this.allowDefault = ((SorterFilter)filter).allowDefault;
        this.color = ((SorterFilter)filter).color;
        this.sizeMode = ((SorterFilter)filter).sizeMode;
        this.min = ((SorterFilter)filter).min;
        this.max = ((SorterFilter)filter).max;
    }

    public abstract Finder getFinder();

    public TransitRequest mapInventory(BlockEntity tile, Direction side, boolean singleItem) {
        if (this.sizeMode && !singleItem) {
            return TransitRequest.definedItem(tile, side, this.min, this.max, this.getFinder());
        }
        return TransitRequest.definedItem(tile, side, singleItem ? 1 : 64, this.getFinder());
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        nbtTags.m_128379_("allowDefault", this.allowDefault);
        nbtTags.m_128405_("color", TransporterUtils.getColorIndex(this.color));
        nbtTags.m_128379_("sizeMode", this.sizeMode);
        nbtTags.m_128405_("min", this.min);
        nbtTags.m_128405_("max", this.max);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        NBTUtils.setBooleanIfPresent(nbtTags, "allowDefault", value -> {
            this.allowDefault = value;
        });
        NBTUtils.setEnumIfPresent(nbtTags, "color", TransporterUtils::readColor, color -> {
            this.color = color;
        });
        NBTUtils.setBooleanIfPresent(nbtTags, "sizeMode", value -> {
            this.sizeMode = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "min", value -> {
            this.min = value;
        });
        NBTUtils.setIntIfPresent(nbtTags, "max", value -> {
            this.max = value;
        });
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.allowDefault);
        buffer.m_130130_(TransporterUtils.getColorIndex(this.color));
        buffer.writeBoolean(this.sizeMode);
        buffer.m_130130_(this.min);
        buffer.m_130130_(this.max);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.allowDefault = dataStream.readBoolean();
        this.color = TransporterUtils.readColor(dataStream.m_130242_());
        this.sizeMode = dataStream.readBoolean();
        this.min = dataStream.m_130242_();
        this.max = dataStream.m_130242_();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.allowDefault, this.sizeMode, this.min, this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterFilter other = (SorterFilter)o;
        return this.allowDefault == other.allowDefault && this.sizeMode == other.sizeMode && this.min == other.min && this.max == other.max && this.color == other.color;
    }
}

