/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.prefab;

import java.util.function.UnaryOperator;
import mekanism.api.text.ILangEntry;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.attribute.AttributeCustomShape;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasDescription;
import mekanism.common.block.interfaces.ITypeBlock;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.content.blocktype.BlockType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockBase<TYPE extends BlockType>
extends BlockMekanism
implements IHasDescription,
ITypeBlock {
    protected final TYPE type;
    private static BlockType cacheType;

    public BlockBase(TYPE type, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
        this(type, (BlockBehaviour.Properties)propertyModifier.apply(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60999_()));
    }

    public BlockBase(TYPE type, BlockBehaviour.Properties properties) {
        super(BlockBase.hack(type, properties));
        this.type = type;
    }

    private static <TYPE extends BlockType> BlockBehaviour.Properties hack(TYPE type, BlockBehaviour.Properties props) {
        cacheType = type;
        type.getAll().forEach(a -> a.adjustProperties(props));
        return props;
    }

    @Override
    public BlockType getType() {
        return this.type == null ? cacheType : this.type;
    }

    @Override
    @NotNull
    public ILangEntry getDescription() {
        return ((BlockType)this.type).getDescription();
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return ((BlockType)this.type).has(Attributes.AttributeCustomResistance.class) ? ((BlockType)this.type).get(Attributes.AttributeCustomResistance.class).resistance() : super.getExplosionResistance(state, world, pos, explosion);
    }

    @Deprecated
    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull PathComputationType pathType) {
        return !((BlockType)this.type).has(AttributeCustomShape.class) && super.m_7357_(state, world, pos, pathType);
    }

    @Deprecated
    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((BlockType)this.type).has(AttributeCustomShape.class)) {
            VoxelShape[] bounds = ((BlockType)this.type).get(AttributeCustomShape.class).bounds();
            if (bounds.length == 1) {
                return bounds[0];
            }
            AttributeStateFacing attr = ((BlockType)this.type).get(AttributeStateFacing.class);
            int index = attr == null ? 0 : attr.getDirection(state).ordinal() - (attr.getFacingProperty() == BlockStateProperties.f_61372_ ? 0 : 2);
            return bounds[index];
        }
        return super.m_5940_(state, world, pos, context);
    }

    public static class BlockBaseModel<BLOCK extends BlockType>
    extends BlockBase<BLOCK>
    implements IStateFluidLoggable {
        public BlockBaseModel(BLOCK blockType, UnaryOperator<BlockBehaviour.Properties> propertyModifier) {
            super(blockType, propertyModifier);
        }

        public BlockBaseModel(BLOCK blockType, BlockBehaviour.Properties properties) {
            super(blockType, properties);
        }
    }
}

