/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.lib.WildcardMatcher;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tags.TagUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;

public final class TagCache {
    private static final Map<String, MatchingStacks> blockTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemTagStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, List<ItemStack>> itemModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<String, MatchingStacks> blockModIDStacks = new Object2ObjectOpenHashMap();
    private static final Map<Material, List<ItemStack>> materialStacks = new Object2ObjectOpenHashMap();
    private static final Map<Block, List<String>> tileEntityTypeTagCache = new Object2ObjectOpenHashMap();
    private static final Object2BooleanMap<String> blockTagBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<String> modIDBlacklistedElements = new Object2BooleanOpenHashMap();
    private static final Object2BooleanMap<Material> materialBlacklistedElements = new Object2BooleanOpenHashMap();

    private TagCache() {
    }

    public static void resetTagCaches() {
        blockTagStacks.clear();
        itemTagStacks.clear();
        tileEntityTypeTagCache.clear();
        blockTagBlacklistedElements.clear();
        modIDBlacklistedElements.clear();
        materialBlacklistedElements.clear();
    }

    public static List<String> getItemTags(@NotNull ItemStack check) {
        return TagCache.getTagsAsStrings(check.m_204131_());
    }

    public static List<String> getTileEntityTypeTags(@NotNull Block block) {
        List<String> tagsAsString;
        if (tileEntityTypeTagCache.containsKey(block)) {
            return tileEntityTypeTagCache.get(block);
        }
        if (block instanceof IHasTileEntity) {
            IHasTileEntity hasTileEntity = (IHasTileEntity)block;
            tagsAsString = TagCache.getTagsAsStrings(TagUtils.tagsStream(ForgeRegistries.BLOCK_ENTITY_TYPES, (BlockEntityType)hasTileEntity.getTileType().get()));
        } else {
            BlockState state = block.m_49966_();
            if (state.m_155947_()) {
                ITagManager manager = TagUtils.manager(ForgeRegistries.BLOCK_ENTITY_TYPES);
                tagsAsString = TagCache.getTagsAsStrings(StreamSupport.stream(ForgeRegistries.BLOCK_ENTITY_TYPES.spliterator(), false).filter(type -> type.m_155262_(state)).flatMap(type -> TagUtils.tagsStream(manager, type)).distinct());
            } else {
                tagsAsString = Collections.emptyList();
            }
        }
        tileEntityTypeTagCache.put(block, tagsAsString);
        return tagsAsString;
    }

    public static <TYPE> List<String> getTagsAsStrings(@NotNull Stream<TagKey<TYPE>> tags) {
        return tags.map(tag -> tag.f_203868_().toString()).toList();
    }

    public static List<ItemStack> getItemTagStacks(@NotNull String tagName) {
        if (itemTagStacks.containsKey(tagName)) {
            return itemTagStacks.get(tagName);
        }
        Set<Item> items = TagCache.collectTagStacks(TagUtils.manager(ForgeRegistries.ITEMS), tagName, item -> item != MekanismBlocks.BOUNDING_BLOCK.m_5456_());
        List<ItemStack> stacks = items.stream().map(ItemStack::new).filter(stack -> !stack.m_41619_()).toList();
        itemTagStacks.put(tagName, stacks);
        return stacks;
    }

    public static MatchingStacks getBlockTagStacks(@NotNull String tagName) {
        if (blockTagStacks.containsKey(tagName)) {
            return blockTagStacks.get(tagName);
        }
        Set<Block> blocks = TagCache.collectTagStacks(TagUtils.manager(ForgeRegistries.BLOCKS), tagName, block -> block != MekanismBlocks.BOUNDING_BLOCK.getBlock());
        return TagCache.getMatching(blockTagStacks, blocks, tagName);
    }

    private static <TYPE extends ItemLike> Set<TYPE> collectTagStacks(ITagManager<TYPE> tagManager, String tagName, Predicate<TYPE> validElement) {
        return tagManager.stream().filter(tag -> WildcardMatcher.matches(tagName, tag.getKey())).flatMap(ITag::stream).filter(validElement).collect(Collectors.toSet());
    }

    private static MatchingStacks getMatching(Map<String, MatchingStacks> cache, Set<Block> blocks, String name) {
        if (blocks.isEmpty()) {
            return MatchingStacks.NONE;
        }
        MatchingStacks matchingStacks = new MatchingStacks(true, blocks.stream().map(ItemStack::new).filter(stack -> !stack.m_41619_()).toList());
        cache.put(name, matchingStacks);
        return matchingStacks;
    }

    public static List<ItemStack> getItemModIDStacks(@NotNull String modName) {
        if (itemModIDStacks.containsKey(modName)) {
            return itemModIDStacks.get(modName);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack stack;
            if (item == MekanismBlocks.BOUNDING_BLOCK.m_5456_() || (stack = new ItemStack((ItemLike)item)).m_41619_() || !WildcardMatcher.matches(modName, MekanismUtils.getModId(stack))) continue;
            stacks.add(stack);
        }
        itemModIDStacks.put(modName, stacks);
        return stacks;
    }

    public static MatchingStacks getBlockModIDStacks(@NotNull String modName) {
        if (blockModIDStacks.containsKey(modName)) {
            return blockModIDStacks.get(modName);
        }
        HashSet<Block> blocks = new HashSet<Block>();
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Block block = (Block)entry.getValue();
            if (block == MekanismBlocks.BOUNDING_BLOCK.getBlock() || !WildcardMatcher.matches(modName, ((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
            blocks.add(block);
        }
        return TagCache.getMatching(blockModIDStacks, blocks, modName);
    }

    public static List<ItemStack> getMaterialStacks(@NotNull ItemStack stack) {
        return TagCache.getMaterialStacks(Block.m_49814_((Item)stack.m_41720_()).m_49966_().m_60767_());
    }

    public static List<ItemStack> getMaterialStacks(@NotNull Material material) {
        if (materialStacks.containsKey(material)) {
            return materialStacks.get(material);
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            ItemStack stack;
            if (block == MekanismBlocks.BOUNDING_BLOCK.getBlock() || block.m_49966_().m_60767_() != material || (stack = new ItemStack((ItemLike)block)).m_41619_()) continue;
            stacks.add(stack);
        }
        materialStacks.put(material, stacks);
        return stacks;
    }

    public static boolean tagHasMinerBlacklisted(@NotNull String tag) {
        if (MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.isEmpty()) {
            return false;
        }
        if (blockTagBlacklistedElements.containsKey((Object)tag)) {
            return blockTagBlacklistedElements.getBoolean((Object)tag);
        }
        boolean hasBlacklisted = TagUtils.manager(ForgeRegistries.BLOCKS).stream().anyMatch(blockTag -> {
            if (!WildcardMatcher.matches(tag, blockTag.getKey())) return false;
            if (!blockTag.stream().anyMatch(MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP::contains)) return false;
            return true;
        });
        blockTagBlacklistedElements.put((Object)tag, hasBlacklisted);
        return hasBlacklisted;
    }

    public static boolean modIDHasMinerBlacklisted(@NotNull String modName) {
        if (MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.isEmpty()) {
            return false;
        }
        if (modIDBlacklistedElements.containsKey((Object)modName)) {
            return modIDBlacklistedElements.getBoolean((Object)modName);
        }
        boolean hasBlacklisted = false;
        for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
            Block block = (Block)entry.getValue();
            if (!MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.contains(block) || !WildcardMatcher.matches(modName, ((ResourceKey)entry.getKey()).m_135782_().m_135827_())) continue;
            hasBlacklisted = true;
            break;
        }
        modIDBlacklistedElements.put((Object)modName, hasBlacklisted);
        return hasBlacklisted;
    }

    public static boolean materialHasMinerBlacklisted(@NotNull ItemStack stack) {
        return TagCache.materialHasMinerBlacklisted(Block.m_49814_((Item)stack.m_41720_()).m_49966_().m_60767_());
    }

    public static boolean materialHasMinerBlacklisted(@NotNull Material material) {
        if (MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.isEmpty()) {
            return false;
        }
        if (materialBlacklistedElements.containsKey((Object)material)) {
            return materialBlacklistedElements.getBoolean((Object)material);
        }
        boolean hasBlacklisted = false;
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (block.m_49966_().m_60767_() != material || !MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.contains(block)) continue;
            hasBlacklisted = true;
            break;
        }
        materialBlacklistedElements.put((Object)material, hasBlacklisted);
        return hasBlacklisted;
    }

    public record MatchingStacks(boolean hasMatch, List<ItemStack> stacks) {
        private static final MatchingStacks NONE = new MatchingStacks(false, Collections.emptyList());
    }
}

