/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonObject;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.mixin.item.crafting.AccessorShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public final class ShapedDurabilityRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;

    public ShapedDurabilityRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> input, ItemStack output, int damageAmount) {
        super(id, group, width, height, input, output);
        this.damageAmount = damageAmount;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.m_7457_((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public static final class Serializer
    implements RecipeSerializer<ShapedDurabilityRecipe> {
        public ShapedDurabilityRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = Serializers.STRING.fromJSON(json, "group", "");
            Map<String, Ingredient> ingredients = AccessorShapedRecipe.bookshelf$keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = AccessorShapedRecipe.bookshelf$shrink(AccessorShapedRecipe.bookshelf$patternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList<Ingredient> inputs = AccessorShapedRecipe.bookshelf$dissolvePattern(pattern, ingredients, width, height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int damageAmount = Serializers.INT.fromJSON(json, "damageAmount", 1);
            return new ShapedDurabilityRecipe(id, group, width, height, inputs, output, damageAmount);
        }

        public ShapedDurabilityRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.m_130277_();
            NonNullList input = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int damageAmount = buffer.readInt();
            return new ShapedDurabilityRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)input, output, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDurabilityRecipe recipe) {
            buffer.writeInt(recipe.m_44220_());
            buffer.writeInt(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

